import '../init'
import { knex } from '../knex'

const run = async () => {
  console.info('migrate…')

  const [latestBatchNo, latestLog] = await knex.migrate.latest()
  if (latestLog.length === 0) {
    console.info(`already up to date\n`)
  } else {
    console.info(`batch ${latestBatchNo} run: ${latestLog.length} migrations \n` + latestLog.join('\n') + '\n')
  }

  console.info('migrations terminées')
  process.exit()
}

run().catch(e => {
  if (e instanceof Error) {
    console.error(e.stack)
  } else {
    console.error(e)
  }
  process.exit(1)
})
