/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.franceconnect;

import fr.insee.keycloak.providers.common.EidasLevel;
import fr.insee.keycloak.providers.common.Utils;
import fr.insee.keycloak.providers.franceconnect.FCEnvironment;
import fr.insee.keycloak.providers.franceconnect.FranceConnectIdentityProvider;
import fr.insee.keycloak.providers.franceconnect.FranceConnectIdentityProviderConfig;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public final class FranceConnectIdentityProviderFactory
extends AbstractIdentityProviderFactory<FranceConnectIdentityProvider>
implements SocialIdentityProviderFactory<FranceConnectIdentityProvider> {
    public static final String FC_PROVIDER_ID = "franceconnect-particulier";
    public static final String FC_PROVIDER_NAME = "France Connect Particulier";
    static final FCEnvironment DEFAULT_FC_ENVIRONMENT = FCEnvironment.INTEGRATION_V1;
    static final List<IdentityProviderMapperModel> FC_PROVIDER_MAPPERS = List.of(Utils.createUserAttributeMapper("franceconnect-particulier", "lastName", "family_name", "lastName"), Utils.createUserAttributeMapper("franceconnect-particulier", "firstName", "given_name", "firstName"), Utils.createUserAttributeMapper("franceconnect-particulier", "email", "email", "email"), Utils.createHardcodedAttributeMapper("franceconnect-particulier", "provider", "provider", "FC"));

    public String getName() {
        return FC_PROVIDER_NAME;
    }

    public String getId() {
        return FC_PROVIDER_ID;
    }

    public FranceConnectIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new FranceConnectIdentityProvider(session, new FranceConnectIdentityProviderConfig(model));
    }

    public FranceConnectIdentityProviderConfig createConfig() {
        return new FranceConnectIdentityProviderConfig();
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        List environments = Stream.of(FCEnvironment.values()).map(Enum::name).collect(Collectors.toList());
        List eidasLevels = Stream.of(EidasLevel.values()).map(Enum::name).collect(Collectors.toList());
        return ProviderConfigurationBuilder.create().property().name("fc_environment").label("Environnement FranceConnect").helpText("Permet de choisir l'environnement FranceConnect. Effet : change les urls vers FranceConnect.").type("List").options(environments).defaultValue((Object)DEFAULT_FC_ENVIRONMENT).add().property().name("eidas_values").label("Niveau de garantie eIDAS").helpText("Permet de fixer le niveau de garantie du compte utilisateur souhait\u00e9. Effet : d\u00e9sactive des fournisseurs d'identit\u00e9s (FI) sur la page de login FranceConnect.").type("List").options(eidasLevels).defaultValue((Object)EidasLevel.EIDAS1).add().build();
    }
}

