/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.franceconnect;

import fr.insee.keycloak.providers.common.Utils;
import java.util.Properties;

enum FCEnvironment {
    INTEGRATION_V1("france-connect.integration.v1"),
    PRODUCTION_V1("france-connect.production.v1"),
    INTEGRATION_V2("france-connect.plus.integration.v2"),
    PRODUCTION_V2("france-connect.plus.production.v2"),
    INTEGRATION_STANDARD_V2("france-connect.standard.integration.v2"),
    PRODUCTION_STANDARD_V2("france-connect.standard.production.v2"),
    INTEGRATION_PLUS_V2("france-connect.plus.integration.v2"),
    PRODUCTION_PLUS_V2("france-connect.plus.production.v2");

    static final String ENVIRONMENT_PROPERTY_NAME = "fc_environment";
    private static final Properties PROPERTIES;
    private final String propertyPrefix;

    private FCEnvironment(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public String getProperty(String key) {
        return PROPERTIES.getProperty(this.propertyPrefix + "." + key);
    }

    static FCEnvironment getOrDefault(String environmentName, FCEnvironment defaultEnvironment) {
        for (FCEnvironment environment : FCEnvironment.values()) {
            if (!environment.name().equalsIgnoreCase(environmentName)) continue;
            return environment;
        }
        return defaultEnvironment;
    }

    static {
        PROPERTIES = Utils.loadProperties("france-connect.properties");
    }
}

