/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.common;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import org.jboss.logging.Logger;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.JWKSHttpUtils;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);
    private static ThreadLocal<Random> random = ThreadLocal.withInitial(() -> new SecureRandom());

    private Utils() {
    }

    public static IdentityProviderMapperModel createUserAttributeMapper(String providerId, String mapperName, String claimAttributeName, String userAttributeName) {
        IdentityProviderMapperModel mapper = new IdentityProviderMapperModel();
        mapper.setName(mapperName);
        mapper.setIdentityProviderMapper("franceconnect-user-attribute-mapper");
        mapper.setIdentityProviderAlias(providerId);
        mapper.setConfig(new HashMap());
        mapper.setSyncMode(IdentityProviderMapperSyncMode.INHERIT);
        mapper.getConfig().put("claim", claimAttributeName);
        mapper.getConfig().put("user.attribute", userAttributeName);
        return mapper;
    }

    public static IdentityProviderMapperModel createHardcodedAttributeMapper(String providerId, String mapperName, String attributeName, String attributeValue) {
        IdentityProviderMapperModel mapper = new IdentityProviderMapperModel();
        mapper.setName(mapperName);
        mapper.setIdentityProviderMapper("hardcoded-attribute-idp-mapper");
        mapper.setIdentityProviderAlias(providerId);
        mapper.setConfig(new HashMap());
        mapper.setSyncMode(IdentityProviderMapperSyncMode.INHERIT);
        mapper.getConfig().put("attribute", attributeName);
        mapper.getConfig().put("attribute.value", attributeValue);
        return mapper;
    }

    public static Properties loadProperties(String propertiesFile) {
        Properties properties;
        block8: {
            Properties properties2 = new Properties();
            InputStream stream = Utils.class.getClassLoader().getResourceAsStream(propertiesFile);
            try {
                properties2.load(stream);
                properties = properties2;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot load properties from file " + propertiesFile, ex);
                }
            }
            stream.close();
        }
        return properties;
    }

    public static JSONWebKeySet getJsonWebKeySetFrom(String jwksUrl, KeycloakSession session) {
        try {
            return JWKSHttpUtils.sendJwksRequest((KeycloakSession)session, (String)jwksUrl);
        }
        catch (IOException ex) {
            logger.warn((Object)("Error when fetching keys on JWKS URL: " + jwksUrl), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public static byte[] transcodeSignatureToDER(byte[] jwsSignature) {
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }

    public static byte[] generateRandomBytes(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[length];
        random.get().nextBytes(buf);
        return buf;
    }
}

