/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.common;

import fr.insee.keycloak.providers.common.AbstractBaseProviderConfig;
import fr.insee.keycloak.providers.common.EidasLevel;
import fr.insee.keycloak.providers.common.Utils;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Optional;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.HMACProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.util.JWKSUtils;
import org.keycloak.vault.VaultStringSecret;

public abstract class AbstractBaseIdentityProvider<T extends AbstractBaseProviderConfig>
extends OIDCIdentityProvider
implements SocialIdentityProvider<OIDCIdentityProviderConfig> {
    protected static final String ACR_CLAIM_NAME = "acr";
    protected JSONWebKeySet jwks;

    protected AbstractBaseIdentityProvider(KeycloakSession session, T config, JSONWebKeySet jwks) {
        super(session, config);
        this.jwks = jwks;
    }

    public T getConfig() {
        return (T)((Object)((AbstractBaseProviderConfig)super.getConfig()));
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new OIDCEndpoint<T>(callback, realm, event, (AbstractOAuth2IdentityProvider)this, this.getConfig());
    }

    public Response keycloakInitiatedBrowserLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        T config = this.getConfig();
        String logoutUrl = config.getLogoutUrl();
        if (logoutUrl == null || logoutUrl.trim().equals("")) {
            return null;
        }
        String idToken = this.getIdTokenForLogout(userSession);
        if (idToken != null && config.isBackchannelSupported()) {
            this.backchannelLogout(userSession, idToken);
            return null;
        }
        String sessionId = userSession.getId();
        UriBuilder logoutUri = UriBuilder.fromUri((String)logoutUrl).queryParam("state", new Object[]{sessionId});
        if (idToken != null) {
            logoutUri.queryParam("id_token_hint", new Object[]{idToken});
        }
        String redirectUri = RealmsResource.brokerUrl((UriInfo)uriInfo).path(IdentityBrokerService.class, "getEndpoint").path(OIDCEndpoint.class, "logoutResponse").build(new Object[]{realm.getName(), config.getAlias()}).toString();
        logoutUri.queryParam("post_logout_redirect_uri", new Object[]{redirectUri});
        return Response.status((Response.Status)Response.Status.FOUND).location(logoutUri.build(new Object[0])).build();
    }

    protected String getIdTokenForLogout(UserSessionModel userSession) {
        return userSession.getNote("FEDERATED_ID_TOKEN");
    }

    protected boolean verify(JWSInput jws) {
        logger.info((Object)("Validating: " + jws.getWireString()));
        T config = this.getConfig();
        if (!config.isValidateSignature()) {
            return true;
        }
        if (Algorithm.HS256.equals((Object)jws.getHeader().getAlgorithm())) {
            try (VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(this.getConfig().getClientSecret());){
                String clientSecret = vaultStringSecret.get().orElse(this.getConfig().getClientSecret());
                boolean bl = HMACProvider.verify((JWSInput)jws, (byte[])clientSecret.getBytes());
                return bl;
            }
        }
        try {
            KeyWrapper publicKey = Optional.ofNullable(JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)this.jwks, (JWK.Use)JWK.Use.SIG).getKeyByKidAndAlg(jws.getHeader().getKeyId(), jws.getHeader().getAlgorithm().name())).or(() -> {
                this.jwks = Utils.getJsonWebKeySetFrom(config.getJwksUrl(), this.session);
                return Optional.ofNullable(JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)this.jwks, (JWK.Use)JWK.Use.SIG).getKeyByKidAndAlg(jws.getHeader().getKeyId(), jws.getHeader().getAlgorithm().name()));
            }).orElse(null);
            if (publicKey == null) {
                logger.error((Object)("No keys found for kid: " + jws.getHeader().getKeyId()));
                return false;
            }
            String algorithm = JavaAlgorithm.getJavaAlgorithm((String)jws.getHeader().getAlgorithm().name());
            Signature verifier = Signature.getInstance(algorithm);
            verifier.initVerify((PublicKey)publicKey.getPublicKey());
            verifier.update(jws.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8));
            byte[] signature = jws.getSignature();
            if (algorithm.endsWith("ECDSA")) {
                signature = Utils.transcodeSignatureToDER(signature);
            }
            return verifier.verify(signature);
        }
        catch (Exception ex) {
            logger.error((Object)"Signature verification failed", (Throwable)ex);
            return false;
        }
    }

    public BrokeredIdentityContext getFederatedIdentity(String response) {
        try {
            BrokeredIdentityContext federatedIdentity = super.getFederatedIdentity(response);
            JsonWebToken idToken = (JsonWebToken)federatedIdentity.getContextData().get("VALIDATED_ID_TOKEN");
            String acrClaim = (String)idToken.getOtherClaims().get(ACR_CLAIM_NAME);
            EidasLevel fcReturnedEidasLevel = EidasLevel.getOrDefault(acrClaim, null);
            EidasLevel expectedEidasLevel = ((AbstractBaseProviderConfig)((Object)this.getConfig())).getEidasLevel();
            if (fcReturnedEidasLevel == null) {
                throw new IdentityBrokerException("The returned eIDAS level cannot be retrieved");
            }
            logger.debugv("Expecting eIDAS level: {0}, actual: {1}", (Object)expectedEidasLevel, (Object)fcReturnedEidasLevel);
            if (fcReturnedEidasLevel.compareTo(expectedEidasLevel) < 0) {
                throw new IdentityBrokerException("The returned eIDAS level is insufficient");
            }
            return federatedIdentity;
        }
        catch (IdentityBrokerException ex) {
            logger.error((Object)("Got response " + response));
            throw ex;
        }
    }

    protected static class OIDCEndpoint<T extends AbstractBaseProviderConfig>
    extends AbstractOAuth2IdentityProvider.Endpoint {
        private final T config;

        public OIDCEndpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event, AbstractOAuth2IdentityProvider provider, T config) {
            super(callback, realm, event, provider);
            this.config = config;
        }

        @GET
        @Path(value="logout_response")
        public Response logoutResponse(@QueryParam(value="state") String state) {
            if (state == null && ((AbstractBaseProviderConfig)((Object)this.config)).isIgnoreAbsentStateParameterLogout()) {
                logger.warn((Object)"using usersession from cookie");
                AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie((KeycloakSession)this.session, (RealmModel)this.realm, (boolean)false);
                if (authResult == null) {
                    return this.noValidUserSession();
                }
                UserSessionModel userSession = authResult.getSession();
                return AuthenticationManager.finishBrowserLogout((KeycloakSession)this.session, (RealmModel)this.realm, (UserSessionModel)userSession, (UriInfo)this.session.getContext().getUri(), (ClientConnection)this.clientConnection, (HttpHeaders)this.headers);
            }
            if (state == null) {
                logger.error((Object)"no state parameter returned");
                this.sendUserSessionNotFoundEvent();
                return ErrorPage.error((KeycloakSession)this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, state);
            if (userSession == null) {
                return this.noValidUserSession();
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                this.sendUserSessionNotFoundEvent();
                return ErrorPage.error((KeycloakSession)this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"sessionNotActiveMessage", (Object[])new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout((KeycloakSession)this.session, (RealmModel)this.realm, (UserSessionModel)userSession, (UriInfo)this.session.getContext().getUri(), (ClientConnection)this.clientConnection, (HttpHeaders)this.headers);
        }

        private Response noValidUserSession() {
            logger.error((Object)"no valid user session");
            this.sendUserSessionNotFoundEvent();
            return ErrorPage.error((KeycloakSession)this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
        }

        private void sendUserSessionNotFoundEvent() {
            EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
            event.event(EventType.LOGOUT);
            event.error("user_session_not_found");
        }
    }
}

