/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.agentconnect;

import fr.insee.keycloak.providers.agentconnect.ACEnvironment;
import fr.insee.keycloak.providers.agentconnect.AgentConnectIdentityProvider;
import fr.insee.keycloak.providers.agentconnect.AgentConnectIdentityProviderConfig;
import fr.insee.keycloak.providers.common.EidasLevel;
import fr.insee.keycloak.providers.common.Utils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public final class AgentConnectIdentityProviderFactory
extends AbstractIdentityProviderFactory<AgentConnectIdentityProvider>
implements SocialIdentityProviderFactory<AgentConnectIdentityProvider> {
    public static final String AC_PROVIDER_ID = "agentconnect";
    public static final String AC_PROVIDER_NAME = "Agent Connect";
    static final ACEnvironment DEFAULT_AC_ENVIRONMENT = ACEnvironment.INTEGRATION_INTERNET;
    static final List<IdentityProviderMapperModel> AC_PROVIDER_MAPPERS = List.of(Utils.createUserAttributeMapper("agentconnect", "lastName", "family_name", "lastName"), Utils.createUserAttributeMapper("agentconnect", "firstName", "given_name", "firstName"), Utils.createUserAttributeMapper("agentconnect", "email", "email", "email"), Utils.createHardcodedAttributeMapper("agentconnect", "provider", "provider", "AC"));

    public String getName() {
        return AC_PROVIDER_NAME;
    }

    public String getId() {
        return AC_PROVIDER_ID;
    }

    public AgentConnectIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new AgentConnectIdentityProvider(session, new AgentConnectIdentityProviderConfig(model));
    }

    public AgentConnectIdentityProviderConfig createConfig() {
        return new AgentConnectIdentityProviderConfig();
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        List environments = Stream.of(ACEnvironment.values()).map(Enum::name).collect(Collectors.toList());
        List eidasLevels = Stream.of(EidasLevel.values()).map(Enum::name).collect(Collectors.toList());
        return ProviderConfigurationBuilder.create().property().name("fc_environment").label("Environnement AgentConnect").helpText("Permet de choisir l'environnement AgentConnect. Effet : change les urls vers AgentConnect.").type("List").options(environments).defaultValue((Object)DEFAULT_AC_ENVIRONMENT).add().property().name("eidas_values").label("Niveau de garantie eIDAS").helpText("Permet de fixer le niveau de garantie du compte utilisateur souhait\u00e9. Effet : d\u00e9sactive des fournisseurs d'identit\u00e9s (FI) sur la page de login AgentConnect.").type("List").options(eidasLevels).defaultValue((Object)EidasLevel.EIDAS1).add().build();
    }
}

