/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.agentconnect;

import fr.insee.keycloak.providers.agentconnect.AgentConnectIdentityProviderConfig;
import fr.insee.keycloak.providers.common.AbstractBaseIdentityProvider;
import fr.insee.keycloak.providers.common.Utils;
import jakarta.ws.rs.core.UriBuilder;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.models.KeycloakSession;

final class AgentConnectIdentityProvider
extends AbstractBaseIdentityProvider<AgentConnectIdentityProviderConfig> {
    AgentConnectIdentityProvider(KeycloakSession session, AgentConnectIdentityProviderConfig config) {
        super(session, config, Utils.getJsonWebKeySetFrom(config.getJwksUrl(), session));
    }

    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        AgentConnectIdentityProviderConfig config = (AgentConnectIdentityProviderConfig)((Object)this.getConfig());
        request.getAuthenticationSession().setClientNote("acr_values", config.getEidasLevel().toString());
        UriBuilder uriBuilder = super.createAuthorizationUrl(request);
        logger.debugv("AgentConnect Authorization Url: {0}", (Object)uriBuilder.build(new Object[0]).toString());
        return uriBuilder;
    }
}

