/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import com.google.auto.service.AutoService;
import jakarta.ws.rs.NotFoundException;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.AccountResourceProvider;
import org.keycloak.services.resource.AccountResourceProviderFactory;
import org.keycloak.services.resources.account.AccountFormService;

@AutoService(value={AccountResourceProviderFactory.class})
public class AccountFormServiceFactory
implements AccountResourceProviderFactory {
    private static final Logger log = Logger.getLogger(AccountFormServiceFactory.class);
    public static final String ID = "account-v1";

    public String getId() {
        return ID;
    }

    private ClientModel getAccountManagementClient(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("account");
        if (client == null || !client.isEnabled()) {
            log.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        return client;
    }

    public AccountResourceProvider create(KeycloakSession session) {
        log.info((Object)"create");
        RealmModel realm = session.getContext().getRealm();
        ClientModel client = this.getAccountManagementClient(realm);
        EventBuilder event = new EventBuilder(realm, session, session.getContext().getConnection());
        return new AccountFormService(session, client, event);
    }

    public void init(Config.Scope config) {
        log.info((Object)"init");
    }

    public void postInit(KeycloakSessionFactory factory) {
        log.info((Object)"postInit");
    }

    public void close() {
        log.info((Object)"close");
    }
}

