/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import jakarta.ws.rs.core.UriBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.authentication.otp.OTPApplicationProvider;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.utils.CredentialHelper;
import org.keycloak.utils.TotpUtils;

public class TotpBean {
    private final RealmModel realm;
    private final String totpSecret;
    private final String totpSecretEncoded;
    private final String totpSecretQrCode;
    private final boolean enabled;
    private KeycloakSession session;
    private final UriBuilder uriBuilder;
    private final List<CredentialModel> otpCredentials;
    private final List<String> supportedApplications;

    public TotpBean(KeycloakSession session, RealmModel realm, UserModel user, UriBuilder uriBuilder) {
        this.session = session;
        this.uriBuilder = uriBuilder;
        this.enabled = user.credentialManager().isConfiguredFor("otp");
        if (this.enabled) {
            List otpCredentials = user.credentialManager().getStoredCredentialsByTypeStream("otp").collect(Collectors.toList());
            if (otpCredentials.isEmpty()) {
                CredentialRepresentation credential = CredentialHelper.createUserStorageCredentialRepresentation((String)"otp");
                this.otpCredentials = Collections.singletonList(RepresentationToModel.toModel((CredentialRepresentation)credential));
            } else {
                this.otpCredentials = otpCredentials;
            }
        } else {
            this.otpCredentials = Collections.EMPTY_LIST;
        }
        this.realm = realm;
        this.totpSecret = HmacOTP.generateSecret((int)20);
        this.totpSecretEncoded = TotpUtils.encode((String)this.totpSecret);
        this.totpSecretQrCode = TotpUtils.qrCode((String)this.totpSecret, (RealmModel)realm, (UserModel)user);
        OTPPolicy otpPolicy = realm.getOTPPolicy();
        this.supportedApplications = session.getAllProviders(OTPApplicationProvider.class).stream().filter(p -> p.supports(otpPolicy)).map(OTPApplicationProvider::getName).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        return this.totpSecretEncoded;
    }

    public String getTotpSecretQrCode() {
        return this.totpSecretQrCode;
    }

    public String getManualUrl() {
        return this.uriBuilder.replaceQueryParam("mode", new Object[]{"manual"}).build(new Object[0]).toString();
    }

    public String getQrUrl() {
        return this.uriBuilder.replaceQueryParam("mode", new Object[]{"qr"}).build(new Object[0]).toString();
    }

    public OTPPolicy getPolicy() {
        return this.realm.getOTPPolicy();
    }

    public List<String> getSupportedApplications() {
        return this.supportedApplications;
    }

    public List<CredentialModel> getOtpCredentials() {
        return this.otpCredentials;
    }
}

