module.exports = `
type GeojsonMultiPolygons {
  type: FeatureCollectionType!
  features: [GeojsonMultiPolygon]
}

type GeojsonMultiPolygon {
  type: FeatureType!
  properties: Titre
  geometry: GeometryMultiPolygon!
}

type GeometryMultiPolygon {
  type: GeometryTypeMultipolygon!
  coordinates: [[[[Float]]]]
}

type GeojsonPoints {
  type: FeatureCollectionType!
  features: [FeaturePoint]
}

type FeaturePoint {
  type: FeatureType!
  geometry: GeometryPoints!
  properites: FeaturePointProperties
}

type FeaturePointProperties {
  groupe: Int
  contour: Int
  point: Int
  nom: String
  description: String
}

type GeometryPoints {
  type: GeometryTypePoint!
  coordinates: [Float]
}

input InputGeojson {
  type: FeatureCollectionType!
  feature: [InputFeature]
}

input InputFeature {
  type: FeatureType!
  geometry: InputGeometry!
}

input InputGeometry {
  type: GeometryType
  coordinates: Json
}

enum FeatureCollectionType {
  FeatureCollection
}

enum FeatureType {
  Feature
}

enum GeometryType {
  MultiPolygon
  Point
}

enum GeometryTypeMultipolygon {
  MultiPolygon
}

enum GeometryTypePoint {
  Point
}`
