package org.mte.numecoeval.referentiel.infrastructure.jpa.entity;

import jakarta.persistence.*;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.experimental.FieldDefaults;
import org.mte.numecoeval.referentiel.infrastructure.jpa.entity.id.MixElectriqueIdEntity;

@Getter
@Setter
@Accessors(chain = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
@Entity
@IdClass(MixElectriqueIdEntity.class)
@Table(name = "REF_MIXELEC")
@EqualsAndHashCode
public class MixElectriqueEntity implements AbstractReferentielEntity {
    @Id
    String pays;
    @Id
    @Column(name = "NOMCRITERE")
    String critere;
    @Column(name = "RACCOURCISANGLAIS")
    String raccourcisAnglais;
    String source;
    Double valeur;
}
