package org.mte.numecoeval.referentiel.infrastructure.jpa.entity;

import jakarta.persistence.*;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.experimental.FieldDefaults;
import org.mte.numecoeval.referentiel.infrastructure.jpa.entity.id.ImpactReseauIdEntity;

@Getter
@Setter
@Accessors(chain = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
@Entity
@IdClass(ImpactReseauIdEntity.class)
@Table(name = "REF_IMPACTRESEAU")
@EqualsAndHashCode
public class ImpactReseauEntity implements AbstractReferentielEntity {
    @Id
    @Column(name = "REFRESEAU", nullable = false)
    String refReseau;
    @Id
    @Column(name = "ETAPEACV", nullable = false)
    String etape;
    @Id
    @Column(name = "NOMCRITERE", nullable = false)
    String critere;
    String source;
    Double valeur;
    @Column(name = "CONSOELECMOYENNE")
    Double consoElecMoyenne;
}
