package org.mte.numecoeval.calculs.infrastructure.service.enrichissement;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.mte.numecoeval.calculs.domain.model.CalculEquipementPhysique;
import org.mte.numecoeval.calculs.infrastructure.client.ReferentielClient;
import org.mte.numecoeval.calculs.referentiels.generated.api.model.HypotheseDTO;
import org.mte.numecoeval.topic.data.EquipementPhysiqueDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;

@Slf4j
@Service
public class EnrichissementEquipementPhysiqueService {

    @Value("${numecoeval.hypotheses.equipementPhysique}")
    private String hypothesesEquipementPhysique;

    @Autowired
    private ReferentielClient referentielClient;

    public CalculEquipementPhysique serviceEnrichissementEquipementPhysique(EquipementPhysiqueDTO equipementPhysiqueDTO) {
        if (equipementPhysiqueDTO == null) return null;

        log.debug("{} - {} - {} : Enrichissement d'un équipement physique : Nom Equipement: {}, Type: {}, Modele: {}",
                equipementPhysiqueDTO.getNomOrganisation(), equipementPhysiqueDTO.getNomLot(), equipementPhysiqueDTO.getDateLot(),
                equipementPhysiqueDTO.getNomEquipementPhysique(), equipementPhysiqueDTO.getType(), equipementPhysiqueDTO.getModele());

        CalculEquipementPhysique calculEquipementPhysique = new CalculEquipementPhysique();

        calculEquipementPhysique.setEquipementPhysique(equipementPhysiqueDTO);

        calculEquipementPhysique.setEtapes(referentielClient.getEtapes());
        calculEquipementPhysique.setCriteres(referentielClient.getCriteres());

        var hypotheses = new ArrayList<HypotheseDTO>();

        Arrays.stream(hypothesesEquipementPhysique.replaceAll(" +", "").split(","))
                .forEach(hypothese -> {
                    var h = referentielClient.getHypothese(hypothese);
                    if (h != null) hypotheses.add(h);
                });

        calculEquipementPhysique.setHypotheses(hypotheses);

        calculEquipementPhysique.setCorrespondanceRefEquipement(referentielClient.getCorrespondanceRefEquipement(equipementPhysiqueDTO.getModele()));
        calculEquipementPhysique.setTypeEquipement(referentielClient.getTypeEquipement(equipementPhysiqueDTO.getType()));

        calculEquipementPhysique.setImpactsEquipement(new ArrayList<>());
        calculEquipementPhysique.setImpactsReseau(new ArrayList<>());
        calculEquipementPhysique.setMixElectriques(new ArrayList<>());
        for (var critere : calculEquipementPhysique.getCriteres()) {
            for (var etape : calculEquipementPhysique.getEtapes()) {
                if (calculEquipementPhysique.getCorrespondanceRefEquipement() != null) {
                    calculEquipementPhysique.getImpactsEquipement().add(
                            referentielClient.getImpactEquipement(
                                    calculEquipementPhysique.getCorrespondanceRefEquipement().getRefEquipementCible(),
                                    critere.getNomCritere(),
                                    etape.getCode()
                            )
                    );
                } else if (calculEquipementPhysique.getTypeEquipement() != null
                        && StringUtils.isNotBlank(calculEquipementPhysique.getTypeEquipement().getRefEquipementParDefaut())) {
                    calculEquipementPhysique.getImpactsEquipement().add(
                            referentielClient.getImpactEquipement(
                                    calculEquipementPhysique.getTypeEquipement().getRefEquipementParDefaut(),
                                    critere.getNomCritere(),
                                    etape.getCode()
                            )
                    );
                }
                calculEquipementPhysique.getImpactsReseau().add(
                        referentielClient.getImpactReseau(
                                "impactReseauMobileMoyen",
                                critere.getNomCritere(),
                                etape.getCode()
                        )
                );
            }

            var mixElec = referentielClient.getMixElectrique(equipementPhysiqueDTO.getPaysDUtilisation(), critere.getNomCritere());
            if (mixElec != null) calculEquipementPhysique.getMixElectriques().add(mixElec);

            if (equipementPhysiqueDTO.getDataCenter() != null
                    && StringUtils.isNotBlank(equipementPhysiqueDTO.getDataCenter().getLocalisation())
                    && !StringUtils.equals(equipementPhysiqueDTO.getPaysDUtilisation(), equipementPhysiqueDTO.getDataCenter().getLocalisation())) {

                var mixElecDataCenter = referentielClient.getMixElectrique(equipementPhysiqueDTO.getDataCenter().getLocalisation(), critere.getNomCritere());
                if (mixElecDataCenter != null) calculEquipementPhysique.getMixElectriques().add(mixElecDataCenter);
            }
        }

        return calculEquipementPhysique;
    }
}
