package org.mte.numecoeval.calculs.infrastructure.controller.rest.calculs;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AllArgsConstructor;
import org.mte.numecoeval.calculs.domain.port.input.service.impl.CalculImpactReseauServiceImpl;
import org.mte.numecoeval.calculs.infrastructure.mapper.DomainMapper;
import org.mte.numecoeval.calculs.infrastructure.service.rest.calculs.CheckIndicateurService;
import org.mte.numecoeval.calculs.rest.generated.api.model.DemandeCalculImpactReseauEquipementPhysiqueRest;
import org.mte.numecoeval.calculs.rest.generated.api.model.IndicateurImpactReseauRest;
import org.mte.numecoeval.calculs.rest.generated.api.server.CalculsReseauApi;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AllArgsConstructor
public class CalculsReseauController implements CalculsReseauApi {

    DomainMapper domainMapper;

    ObjectMapper objectMapper;

    CheckIndicateurService checkIndicateurService;
    
    /**
     * POST /calculs/reseau/equipementPhysique
     *
     * @param demandeCalculImpactReseauEquipementPhysiqueRest (required)
     * @return la liste d'indicateurs calcules
     */
    @Override
    public ResponseEntity<IndicateurImpactReseauRest> calculerImpactReseau(DemandeCalculImpactReseauEquipementPhysiqueRest demandeCalculImpactReseauEquipementPhysiqueRest) {
        var demandeCalcul = domainMapper.toDomain(demandeCalculImpactReseauEquipementPhysiqueRest);

        var indicateur = new CalculImpactReseauServiceImpl(
                objectMapper
        ).calculerImpactReseau(demandeCalcul);

        return checkIndicateurService.isOk(indicateur.getStatutIndicateur()) ?
                ResponseEntity.ok(domainMapper.toRest(indicateur)) :
                ResponseEntity.badRequest().body(domainMapper.toRest(indicateur));
    }
}
