package org.mte.numecoeval.calculs.infrastructure.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.mte.numecoeval.calculs.domain.port.input.service.*;
import org.mte.numecoeval.calculs.domain.port.input.service.impl.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DomainConfiguration {

    @Bean
    public DureeDeVieEquipementPhysiqueService dureeDeVieEquipementPhysiqueService() {
        return new DureeDeVieEquipementPhysiqueServiceImpl();
    }

    @Bean
    public CalculImpactEquipementPhysiqueService calculImpactEquipementPhysiqueService(DureeDeVieEquipementPhysiqueService dureeDeVieEquipementPhysiqueService, ObjectMapper objectMapper) {
        return new CalculImpactEquipementPhysiqueServiceImpl(
                dureeDeVieEquipementPhysiqueService,
                objectMapper
        );
    }

    @Bean
    CalculImpactEquipementVirtuelService calculImpactEquipementVirtuelService(ObjectMapper objectMapper) {
        return new CalculImpactEquipementVirtuelServiceImpl(objectMapper);
    }

    @Bean
    CalculImpactApplicationService calculImpactApplicationService(ObjectMapper objectMapper) {
        return new CalculImpactApplicationServiceImpl(objectMapper);
    }


    @Bean
    public CalculImpactReseauService calculImpactReseauService(ObjectMapper objectMapper) {
        return new CalculImpactReseauServiceImpl(
                objectMapper
        );
    }

    @Bean
    CalculImpactMessagerieService calculImpactMessagerieService(ObjectMapper objectMapper) {
        return new CalculImpactMessagerieServiceImpl(objectMapper);
    }

}
