package org.mte.numecoeval.referentiel.infrastructure.mapper;

import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mte.numecoeval.referentiel.domain.model.FacteurCaracterisation;
import org.mte.numecoeval.referentiel.domain.model.ImpactReseau;
import org.mte.numecoeval.referentiel.domain.model.id.ImpactReseauId;
import org.mte.numecoeval.referentiel.infrastructure.restapi.dto.ImpactReseauDTO;
import org.mte.numecoeval.referentiel.infrastructure.restapi.dto.id.ImpactReseauIdDTO;

import java.util.List;

@Mapper(componentModel = "spring")

public interface ImpactReseauMapper {

    @Mapping(source = "etape", target = "etapeACV")
    ImpactReseauDTO toDTO(ImpactReseau impactReseau);

    @Mapping(source = "etapeACV", target = "etape")
    ImpactReseau toDomain(ImpactReseauDTO impactReseauDTO);

    @Mapping(source = "etapeACV", target = "etape")
    ImpactReseauId toDomainId(ImpactReseauIdDTO idImpactReseauDTO);

    List<ImpactReseau> toDomainsFromDTO(List<ImpactReseauDTO> dtos);

    @Mapping(target = "nom", source = "refReseau")
    @Mapping(target = "niveau", expression = "java(org.mte.numecoeval.referentiel.utils.Constants.RESEAU_NIVEAU)")
    @Mapping(target = "tiers", expression = "java(org.mte.numecoeval.referentiel.utils.Constants.RESEAU_TIERS)")
    FacteurCaracterisation toFacteurCaracterisation(ImpactReseau impactReseau);

    List<FacteurCaracterisation> toFacteurCaracterisations(List<ImpactReseau> impactReseaux);

    @Mapping(target = "refReseau", source = "nom")
    ImpactReseau toImpactReseau(FacteurCaracterisation facteurCaracterisation);

    List<ImpactReseau> toImpactReseaux(List<FacteurCaracterisation> facteurCaracterisations);
}
