package org.mte.numecoeval.calculs.domain.data.demande;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.mte.numecoeval.calculs.domain.data.entree.EquipementPhysique;
import org.mte.numecoeval.calculs.domain.data.referentiel.*;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Builder
@AllArgsConstructor
@Getter
@Setter
public class DemandeCalculImpactEquipementPhysique {

    LocalDateTime dateCalcul;

    EquipementPhysique equipementPhysique;

    ReferentielEtapeACV etape;

    ReferentielCritere critere;

    ReferentielTypeEquipement typeEquipement;

    ReferentielCorrespondanceRefEquipement correspondanceRefEquipement;

    List<ReferentielHypothese> hypotheses;

    List<ReferentielImpactEquipement> impactEquipements;

    List<ReferentielMixElectrique> mixElectriques;

    public Optional<ReferentielHypothese> getHypotheseFromCode(String code) {
        if (code == null || hypotheses == null) {
            return Optional.empty();
        }

        return hypotheses.stream()
                .filter(hypothese -> code.equals(hypothese.getCode()))
                .findFirst();
    }

    public List<ReferentielHypothese> getHypothesesStartingWith(String startString) {
        return hypotheses == null ? List.of() : hypotheses.stream()
                .filter(hypothese -> hypothese.getCode().startsWith(startString))
                .toList();
    }

    public Optional<ReferentielImpactEquipement> getImpactEquipement(String refEquipement) {
        if (refEquipement == null || impactEquipements == null) {
            return Optional.empty();
        }
        return impactEquipements.stream()
                .filter(Objects::nonNull)
                .filter(impactEquipement -> refEquipement.equals(impactEquipement.getRefEquipement())
                        && critere.getNomCritere().equals(impactEquipement.getCritere())
                        && etape.getCode().equals(impactEquipement.getEtape())
                )
                .findFirst();
    }

    public Optional<ReferentielMixElectrique> getMixElectrique(String pays) {
        if (pays == null || mixElectriques == null) {
            return Optional.empty();
        }
        return mixElectriques.stream()
                .filter(Objects::nonNull)
                .filter(mixElectrique -> pays.equals(mixElectrique.getPays())
                        && critere.getNomCritere().equals(mixElectrique.getCritere())
                )
                .findFirst();
    }

    public String getRefEquipementCible() {
        if (correspondanceRefEquipement != null) {
            return correspondanceRefEquipement.getRefEquipementCible();
        }
        return null;
    }

    public String getRefEquipementParDefaut() {
        if (typeEquipement != null) {
            return typeEquipement.getRefEquipementParDefaut();
        }
        return null;
    }
}
