package org.mte.numecoeval.referentiel.infrastructure.restapi.controller.facteurcaracterisation;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.mte.numecoeval.referentiel.infrastructure.restapi.dto.ErrorResponseDTO;
import org.mte.numecoeval.referentiel.infrastructure.restapi.dto.FacteurCaracterisationDTO;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

public interface ReferentielFacteurCaracterisationRestApi {

    @Operation(summary = "Endpoint interne à NumEcoEval - Récupération d'un Facteur de Caractérisation",
            description = """
                    Endpoint interne utilisé dans la génération des indicateurs par le module api-calcul de NumEcoEval.
                    Récupération d'un impact équipement en fonction de 3 paramètres:
                    <ul>
                        <li>Le nom du facteur de caractérisation: nom</li>
                        <li>L'étape ACV: etape</li>
                        <li>Le critère d'impact: critere</li>
                    </ul>
                    .
                    """,
            tags = "Interne NumEcoEval",
            operationId = "getFacteurCaracterisation")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Facteur Caractérisation trouvé",
                    content = {@Content(mediaType = "application/json", schema = @Schema(implementation = FacteurCaracterisationDTO.class))}),
            @ApiResponse(responseCode = "400", description = "Invalid request", content = {@Content(mediaType = "application/json",
                    schema = @Schema(implementation = ErrorResponseDTO.class))}),
            @ApiResponse(responseCode = "404", description = "Facteur Caractérisation non trouvé", content = {@Content(mediaType = "application/json",
                    schema = @Schema(implementation = ErrorResponseDTO.class))})})
    @GetMapping(path = "/referentiel/facteursCaracterisation", produces = MediaType.APPLICATION_JSON_VALUE)
    FacteurCaracterisationDTO get(
            @RequestParam
            @Schema(description = "Nom du facteur de caractérisation recherché") final String nom,
            @RequestParam
            @Schema(description = "Nom du critère d'impact écologique") final String critere,
            @RequestParam
            @Schema(description = "Code de l'étape ACV") final String etapeacv
    );

}
