package org.mte.numecoeval.referentiel.infrastructure.jpa.repository;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.transaction.Transactional;
import org.mte.numecoeval.referentiel.infrastructure.jpa.entity.FacteurCaracterisationEntity;
import org.mte.numecoeval.referentiel.infrastructure.jpa.entity.id.FacteurCaracterisationIdEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.rest.core.annotation.RepositoryRestResource;

import java.util.List;
import java.util.Optional;

@RepositoryRestResource(path = "FacteurCaracterisation", itemResourceRel = "FacteursCaracterisation")
@Tag(name = "FacteurCaracterisation - CRUD/Spring Data REST")
public interface FacteurCaracterisationRepository extends JpaRepository<FacteurCaracterisationEntity, FacteurCaracterisationIdEntity> {

    @Transactional
    @Modifying
    void deleteByNiveauAndCategorie(String niveau, String categorie);

    @Transactional
    @Modifying
    void deleteByNiveau(String niveau);

    @Transactional
    @Modifying
    void deleteByNiveauAndTiers(String niveau, String tiers);

    Optional<FacteurCaracterisationEntity> findByNiveauAndCategorieAndLocalisationAndCritere(String niveau, String categorie, String localisation, String critere);

    Optional<FacteurCaracterisationEntity> findByNomAndEtapeAndCritere(String nom, String etape, String critere);

    List<FacteurCaracterisationEntity> findByNiveauAndCategorie(String niveau, String categorie);

    List<FacteurCaracterisationEntity> findByNiveauAndTiers(String niveau, String tiers);

    List<FacteurCaracterisationEntity> findByNiveau(String niveau);
}
