package org.mte.numecoeval.referentiel.infrastructure.jpa.entity;

import jakarta.persistence.*;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.experimental.FieldDefaults;
import org.mte.numecoeval.referentiel.infrastructure.jpa.entity.id.ImpactEquipementIdEntity;

@Getter
@Setter
@Accessors(chain = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
@Entity
@IdClass(ImpactEquipementIdEntity.class)
@Table(name = "REF_IMPACTEQUIPEMENT")
@EqualsAndHashCode
public class ImpactEquipementEntity implements AbstractReferentielEntity {
    @Id
    @Column(name = "REFEQUIPEMENT")
    String refEquipement;
    @Id
    @Column(name = "ETAPEACV")
    String etape;
    @Id
    @Column(name = "NOMCRITERE")
    String critere;
    String source;
    String type;
    Double valeur;
    Double consoElecMoyenne;
    String description;
}
