package org.mte.numecoeval.referentiel.infrastructure.jpa.adapter;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.mte.numecoeval.referentiel.domain.exception.ReferentielException;
import org.mte.numecoeval.referentiel.domain.model.FacteurCaracterisation;
import org.mte.numecoeval.referentiel.domain.model.ImpactReseau;
import org.mte.numecoeval.referentiel.domain.model.id.ImpactReseauId;
import org.mte.numecoeval.referentiel.domain.ports.output.ReferentielPersistencePort;
import org.mte.numecoeval.referentiel.infrastructure.jpa.entity.FacteurCaracterisationEntity;
import org.mte.numecoeval.referentiel.infrastructure.jpa.repository.FacteurCaracterisationRepository;
import org.mte.numecoeval.referentiel.infrastructure.mapper.FacteurCaracterisationMapper;
import org.mte.numecoeval.referentiel.infrastructure.mapper.ImpactReseauMapper;
import org.mte.numecoeval.referentiel.utils.Constants;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Optional;


@Service
@Slf4j
@AllArgsConstructor

public class ImpactReseauJpaAdapter implements ReferentielPersistencePort<ImpactReseau, ImpactReseauId> {
    FacteurCaracterisationRepository facteurCaracterisationRepository;
    ImpactReseauMapper reseauMapper;
    FacteurCaracterisationMapper facteurCaracterisationMapper;

    @Override
    public ImpactReseau save(ImpactReseau facteurImpact) throws ReferentielException {
        var facteurCaracterisation = reseauMapper.toFacteurCaracterisation(facteurImpact);
        var entityToSave = facteurCaracterisationMapper.toEntity(facteurCaracterisation);
        if (entityToSave != null) {
            facteurCaracterisationRepository.save(entityToSave);
            return facteurImpact;
        }
        return null;
    }

    @Override
    public void saveAll(Collection<ImpactReseau> facteursImpacts) throws ReferentielException {
        List<FacteurCaracterisation> facteurCaracterisationList = reseauMapper.toFacteurCaracterisations(facteursImpacts.stream().toList());
        facteurCaracterisationRepository.saveAll(facteurCaracterisationMapper.toEntities(facteurCaracterisationList));
    }


    @Override
    public ImpactReseau get(ImpactReseauId id) throws ReferentielException {
        if (id != null) {
            Optional<FacteurCaracterisationEntity> facteurCaracterisationEntities = facteurCaracterisationRepository.findByNomAndEtapeAndCritere(id.getRefReseau(), id.getEtape(), id.getCritere());
            if (facteurCaracterisationEntities.isPresent()) {
                return reseauMapper.toImpactReseau(facteurCaracterisationMapper.toDomain(facteurCaracterisationEntities.get()));
            } else {
                throw new ReferentielException("Référence réseau non trouvée pour l'id " + id);
            }
        }
        throw new ReferentielException("Référence réseau non trouvée pour l'id null");
    }

    @Override
    public void purge() {
        facteurCaracterisationRepository.deleteByNiveauAndTiers(Constants.RESEAU_NIVEAU, Constants.RESEAU_TIERS);
    }

    @Override
    public List<ImpactReseau> getAll() {
        return reseauMapper.toImpactReseaux(facteurCaracterisationMapper.toDomains(facteurCaracterisationRepository.findByNiveauAndTiers(Constants.RESEAU_NIVEAU, Constants.RESEAU_TIERS)));
    }

}
