-- Creation des tables indicateurs
CREATE TABLE IF NOT EXISTS ind_indicateur_impact_equipement_physique
(
    date_calcul                timestamp    NULL,
    date_lot                   date         NULL,
    nom_lot                    varchar(255) NULL,
    etapeacv                   varchar(255) NULL,
    critere                    varchar(255) NULL,
    "source"                   varchar(255) NULL,
    statut_indicateur          varchar(255) NULL,
    trace                      text         NULL,
    version_calcul             varchar(255) NULL,
    conso_elec_moyenne         float8       NULL,
    impact_unitaire            float8       NULL,
    quantite                   int4         NULL,
    statut_equipement_physique varchar(255) NULL,
    type_equipement            varchar(255) NULL,
    unite                      varchar(255) NULL,
    nom_entite                 varchar(255) NULL,
    nom_organisation           varchar(255) NULL,
    nom_source_donnee          varchar(255) NULL,
    nom_equipement             varchar(255) NULL
);

CREATE TABLE IF NOT EXISTS ind_indicateur_impact_equipement_virtuel
(
    date_calcul            timestamp    NULL,
    date_lot               date         NULL,
    nom_lot                varchar(255) NULL,
    etapeacv               varchar(255) NULL,
    critere                varchar(255) NULL,
    nom_organisation       varchar(255) NULL,
    nom_source_donnee      varchar(255) NULL,
    nom_equipement         varchar(255) NULL,
    nom_equipement_virtuel varchar(255) NULL,
    nom_entite             varchar(255) NULL,
    "source"               varchar(255) NULL,
    statut_indicateur      varchar(255) NULL,
    trace                  text         NULL,
    version_calcul         varchar(255) NULL,
    impact_unitaire        float8       NULL,
    unite                  varchar(255) NULL,
    conso_elec_moyenne     float8       NULL,
    "cluster"              varchar(255) NULL
);

CREATE TABLE IF NOT EXISTS ind_indicateur_impact_application
(
    date_calcul               timestamp    NULL,
    date_lot                  date         NULL,
    nom_lot                   varchar(255) NULL,
    etapeacv                  varchar(255) NULL,
    critere                   varchar(255) NULL,
    nom_organisation          varchar(255) NULL,
    nom_source_donnee         varchar(255) NULL,
    nom_application           varchar(255) NULL,
    type_environnement        varchar(255) NULL,
    nom_equipement_physique   varchar(255) NULL,
    nom_equipement_virtuel    varchar(255) NULL,
    nom_entite                varchar(255) NULL,
    "source"                  varchar(255) NULL,
    statut_indicateur         varchar(255) NULL,
    trace                     text         NULL,
    version_calcul            varchar(255) NULL,
    domaine                   varchar(255) NULL,
    sous_domaine              varchar(255) NULL,
    impact_unitaire           float8       NULL,
    unite                     varchar(255) NULL,
    conso_elec_moyenne        float8       NULL
);

CREATE TABLE IF NOT EXISTS ind_indicateur_impact_messagerie
(
    date_calcul            timestamp    NULL,
    date_lot               date         NULL,
    nom_lot                varchar(255) NULL,
    nom_organisation       varchar(255) NULL,
    nom_source_donnee      varchar(255) NULL,
    critere                varchar(255) NULL,
    mois_annee             date         NULL,
    nom_entite             varchar(255) NULL,
    "source"               varchar(255) NULL,
    statut_indicateur      varchar(255) NULL,
    trace                  text         NULL,
    version_calcul         varchar(255) NULL,
    impact_mensuel         float8       NULL,
    unite                  varchar(255) NULL,
    nombre_mail_emis       float8       NULL,
    volume_total_mail_emis float8       NULL
);

CREATE TABLE IF NOT EXISTS ind_indicateur_impact_reseau
(
    date_calcul          timestamp    NULL,
    date_lot             date         NULL,
    nom_lot              varchar(255) NULL,
    etapeacv             varchar(255) NULL,
    critere              varchar(255) NULL,
    "source"             varchar(255) NULL,
    statut_indicateur    varchar(255) NULL,
    trace                text         NULL,
    version_calcul       varchar(255) NULL,
    impact_unitaire      float8       NULL,
    unite                varchar(255) NULL,
    nom_entite           varchar(255) NULL,
    nom_organisation     varchar(255) NULL,
    nom_source_donnee    varchar(255) NULL,
    nom_equipement       varchar(255) NULL
);

ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_physique ADD COLUMN IF NOT EXISTS date_lot_discriminator DATE NOT NULL DEFAULT '1970-01-01';
UPDATE                ind_indicateur_impact_equipement_physique SET date_lot_discriminator = coalesce(date_lot, '1970-01-01') where date_lot_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_reseau              ADD COLUMN IF NOT EXISTS date_lot_discriminator DATE NOT NULL DEFAULT '1970-01-01';
UPDATE                ind_indicateur_impact_reseau              SET date_lot_discriminator = coalesce(date_lot, '1970-01-01') where date_lot_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_virtuel  ADD COLUMN IF NOT EXISTS date_lot_discriminator DATE NOT NULL DEFAULT '1970-01-01';
UPDATE                ind_indicateur_impact_equipement_virtuel  SET date_lot_discriminator = coalesce(date_lot, '1970-01-01') where date_lot_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_application         ADD COLUMN IF NOT EXISTS date_lot_discriminator DATE NOT NULL DEFAULT '1970-01-01';
UPDATE                ind_indicateur_impact_application         SET date_lot_discriminator = coalesce(date_lot, '1970-01-01') where date_lot_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_messagerie          ADD COLUMN IF NOT EXISTS date_lot_discriminator DATE NOT NULL DEFAULT '1970-01-01';
UPDATE                ind_indicateur_impact_messagerie          SET date_lot_discriminator = coalesce(date_lot, '1970-01-01') where date_lot_discriminator is null;

ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_physique ADD COLUMN IF NOT EXISTS nom_organisation_discriminator varchar(255) NOT NULL DEFAULT '';
ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_physique ALTER COLUMN nom_organisation_discriminator SET NOT NULL;
ALTER TABLE IF EXISTS ind_indicateur_impact_reseau              ADD COLUMN IF NOT EXISTS nom_organisation_discriminator varchar(255) NOT NULL DEFAULT '';
ALTER TABLE IF EXISTS ind_indicateur_impact_reseau              ALTER COLUMN nom_organisation_discriminator SET NOT NULL;
ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_virtuel  ADD COLUMN IF NOT EXISTS nom_organisation_discriminator varchar(255) NOT NULL DEFAULT '';
ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_virtuel  ALTER COLUMN nom_organisation_discriminator SET NOT NULL;
ALTER TABLE IF EXISTS ind_indicateur_impact_application         ADD COLUMN IF NOT EXISTS nom_organisation_discriminator varchar(255) NOT NULL DEFAULT '';
ALTER TABLE IF EXISTS ind_indicateur_impact_application         ALTER COLUMN nom_organisation_discriminator SET NOT NULL;
ALTER TABLE IF EXISTS ind_indicateur_impact_messagerie          ADD COLUMN IF NOT EXISTS nom_organisation_discriminator varchar(255) NOT NULL DEFAULT '';
ALTER TABLE IF EXISTS ind_indicateur_impact_messagerie          ALTER COLUMN nom_organisation_discriminator SET NOT NULL;

ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_physique ADD COLUMN IF NOT EXISTS nom_entite_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_equipement_physique SET nom_entite_discriminator = coalesce(nom_entite, '') where nom_entite_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_reseau              ADD COLUMN IF NOT EXISTS nom_entite_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_reseau              SET nom_entite_discriminator = coalesce(nom_entite, '') where nom_entite_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_virtuel  ADD COLUMN IF NOT EXISTS nom_entite_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_equipement_virtuel  SET nom_entite_discriminator = coalesce(nom_entite, '') where nom_entite_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_application         ADD COLUMN IF NOT EXISTS nom_entite_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_application         SET nom_entite_discriminator = coalesce(nom_entite, '') where nom_entite_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_messagerie          ADD COLUMN IF NOT EXISTS nom_entite_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_messagerie          SET nom_entite_discriminator = coalesce(nom_entite, '') where nom_entite_discriminator is null;

ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_physique ADD COLUMN IF NOT EXISTS nom_source_donnee_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_equipement_physique SET nom_source_donnee_discriminator = coalesce(nom_source_donnee, '') where nom_source_donnee_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_reseau              ADD COLUMN IF NOT EXISTS nom_source_donnee_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_reseau              SET nom_source_donnee_discriminator = coalesce(nom_source_donnee, '') where nom_source_donnee_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_equipement_virtuel  ADD COLUMN IF NOT EXISTS nom_source_donnee_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_equipement_virtuel  SET nom_source_donnee_discriminator = coalesce(nom_source_donnee, '') where nom_source_donnee_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_application         ADD COLUMN IF NOT EXISTS nom_source_donnee_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_application         SET nom_source_donnee_discriminator = coalesce(nom_source_donnee, '') where nom_source_donnee_discriminator is null;
ALTER TABLE IF EXISTS ind_indicateur_impact_messagerie          ADD COLUMN IF NOT EXISTS nom_source_donnee_discriminator varchar(255) NOT NULL DEFAULT '';
UPDATE                ind_indicateur_impact_messagerie          SET nom_source_donnee_discriminator = coalesce(nom_source_donnee, '') where nom_source_donnee_discriminator is null;


CREATE INDEX IF NOT EXISTS idx_ind_eq_p__nom_lot_nom_equipement   ON ind_indicateur_impact_equipement_physique (nom_lot, nom_equipement);
CREATE INDEX IF NOT EXISTS idx_ind_eq_v__nom_lot_nom_equipement   ON ind_indicateur_impact_equipement_virtuel (nom_lot, nom_equipement);
CREATE INDEX IF NOT EXISTS idx_ind_app__nom_lot_nom_equipement    ON ind_indicateur_impact_application (nom_lot, nom_equipement_physique);
CREATE INDEX IF NOT EXISTS idx_ind_reseau__nom_lot_nom_equipement ON ind_indicateur_impact_reseau (nom_lot, nom_equipement);

-- Lignes a supprimer dans les futures versions
ALTER TABLE ind_indicateur_impact_equipement_virtuel ADD COLUMN IF NOT EXISTS nom_equipement_virtuel VARCHAR(255);
ALTER TABLE ind_indicateur_impact_application        ADD COLUMN IF NOT EXISTS nom_equipement_virtuel VARCHAR(255);

