package org.mte.numecoeval.expositiondonneesentrees.infrastructure.jpa.repository;

import org.mte.numecoeval.expositiondonneesentrees.infrastructure.jpa.entity.DonneesEntreesEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface DonneesEntreesRepository extends JpaRepository<DonneesEntreesEntity, Long> {
    @Transactional
    @Modifying
    @Query("""
              UPDATE DonneesEntreesEntity dee
              SET dee.dureeUsage = :dureeUsage
              WHERE dee.nomLot = :nomLot
            """)
    int updateDonneesEntreesDureeUsage(
            @Param("dureeUsage") String dureeUsage,
            @Param("nomLot") String nomLot
    );
}
