package org.mte.numecoeval.referentiel.infrastructure.adapter.export;

import org.apache.commons.csv.CSVPrinter;
import org.mte.numecoeval.referentiel.domain.model.ImpactReseau;
import org.mte.numecoeval.referentiel.domain.ports.input.impl.ImportImpactReseauPortImpl;
import org.mte.numecoeval.referentiel.domain.ports.output.ReferentielCsvExportService;
import org.mte.numecoeval.referentiel.infrastructure.jpa.repository.FacteurCaracterisationRepository;
import org.mte.numecoeval.referentiel.infrastructure.mapper.FacteurCaracterisationMapper;
import org.mte.numecoeval.referentiel.infrastructure.mapper.ImpactReseauMapper;
import org.mte.numecoeval.referentiel.utils.Constants;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;

@Service
public class ImpactReseauCsvExportService extends ReferentielCsvExportService<ImpactReseau> {
    private final FacteurCaracterisationRepository repository;
    private final FacteurCaracterisationMapper facteurCaracterisationMapper;
    private final ImpactReseauMapper reseauMapper;

    public ImpactReseauCsvExportService(FacteurCaracterisationRepository repository, FacteurCaracterisationMapper facteurCaracterisationMapper, ImpactReseauMapper reseauMapper) {
        super(ImpactReseau.class);
        this.repository = repository;
        this.facteurCaracterisationMapper = facteurCaracterisationMapper;
        this.reseauMapper = reseauMapper;

    }

    @Override
    public String[] getHeaders() {
        return ImportImpactReseauPortImpl.getHeaders();
    }

    @Override
    public List<ImpactReseau> getObjectsToWrite() {
        var facteurCaracterisationList = facteurCaracterisationMapper.toDomains(repository.findByNiveauAndTiers(Constants.RESEAU_NIVEAU, Constants.RESEAU_TIERS));
        return reseauMapper.toImpactReseaux(facteurCaracterisationList);
    }

    @Override
    protected String getObjectId(ImpactReseau object) {
        return String.join("-", object.getRefReseau(), object.getEtape(), object.getCritere());
    }

    @Override
    public void printRecord(CSVPrinter csvPrinter, ImpactReseau objectToWrite) throws IOException {
        csvPrinter.printRecord(
                objectToWrite.getRefReseau(),
                objectToWrite.getEtape(),
                objectToWrite.getCritere(),
                formatDouble(objectToWrite.getValeur()),
                formatDouble(objectToWrite.getConsoElecMoyenne()),
                objectToWrite.getSource()
        );
    }

}
