package org.mte.numecoeval.calculs.infrastructure.mapper;

import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mte.numecoeval.calculs.domain.data.referentiel.*;
import org.mte.numecoeval.calculs.referentiels.generated.api.model.*;

import java.util.List;

@Mapper(componentModel = "spring")
public interface ReferentielMapper {

    ReferentielEtapeACV toEtape(EtapeDTO etapeDTO);

    ReferentielCritere toCritere(CritereDTO critereDTO);

    @Mapping(source = "valeur", target = "impactReseauMobileMoyen")
    ReferentielImpactReseau toImpactReseau(ImpactReseauDTO impactReseauDTO);

    List<ReferentielImpactReseau> toListImpactReseau(List<ImpactReseauDTO> impactReseauDTO);

    ReferentielHypothese toHypothese(HypotheseDTO hypotheseDTO);

    List<ReferentielHypothese> toListHypothese(List<HypotheseDTO> hypotheseDTO);

    ReferentielFacteurCaracterisation toFacteurCaracterisation(FacteurCaracterisationDTO facteurCaracterisationDTO);

    List<ReferentielFacteurCaracterisation> toListFacteurCaracterisation(List<FacteurCaracterisationDTO> facteurCaracterisationDTO);

    ReferentielImpactEquipement toImpactEquipement(ImpactEquipementDTO impactEquipementDTO);

    List<ReferentielImpactEquipement> toListImpactEquipement(List<ImpactEquipementDTO> impactEquipementDTO);

    ReferentielMixElectrique toMixElectrique(MixElectriqueDTO mixElectriqueDTO);

    List<ReferentielMixElectrique> toListMixElectrique(List<MixElectriqueDTO> mixElectriqueDTO);

    ReferentielImpactMessagerie toImpactMessagerie(ImpactMessagerieDTO impactMessagerieDTO);

    List<ReferentielImpactMessagerie> toListImpactMessagerie(List<ImpactMessagerieDTO> impactMessagerieDTO);

    ReferentielCorrespondanceRefEquipement toCorrespondanceRefEquipement(CorrespondanceRefEquipementDTO dto);

    ReferentielTypeEquipement toTypeEquipement(TypeEquipementDTO dto);

    ReferentielTypeItem toTypeItem(TypeItemDTO dto);
}
