package org.mte.numecoeval.referentiel.infrastructure.init;

import jakarta.annotation.PostConstruct;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.mte.numecoeval.referentiel.domain.exception.ReferentielException;
import org.mte.numecoeval.referentiel.infrastructure.jpa.adapter.TypeItemJpaAdapter;
import org.mte.numecoeval.referentiel.infrastructure.jpa.entity.TypeEquipementEntity;
import org.mte.numecoeval.referentiel.infrastructure.jpa.repository.TypeEquipementRepository;
import org.mte.numecoeval.referentiel.infrastructure.mapper.TypeEquipementMapper;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
@AllArgsConstructor
public class MigrationToRefTypeItem {

    private TypeEquipementRepository typeEquipementRepository;
    private TypeEquipementMapper typeEquipementMapper;
    private TypeItemJpaAdapter typeItemJpaAdapter;

    @PostConstruct
    public void init() throws ReferentielException {
        log.info("démarrage de la migration de la table ref_type_equipement vers ref_type_item");
        List<TypeEquipementEntity> typesEquipement = typeEquipementRepository.findAll();
        if (!typesEquipement.isEmpty()) {
            log.info("migration des référentiels de types d'équipements existants vers la nouvelle table");
            typeItemJpaAdapter.saveAll(typeEquipementMapper.toTypesItem(typeEquipementMapper.toDomaines(typesEquipement)));
            typeEquipementRepository.deleteAll();
            log.info("fin de la migration de la table ref_type_equipement vers ref_type_item");
        }
    }
}
