package org.mte.numecoeval.calculs.infrastructure.service.calcul;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mte.numecoeval.calculs.domain.model.CalculEquipementPhysique;

import java.util.List;

@ExtendWith(MockitoExtension.class)
class CalculReseauServiceTest {

    @InjectMocks
    CalculReseauService calculReseauService;

    private static final ObjectMapper mapper = new ObjectMapper().registerModule(new JavaTimeModule());

    @Test
    void testCalculImpactReseau_nullCases() throws JsonProcessingException {
        Assertions.assertEquals(List.of(), calculReseauService.calculImpactReseau(null));

        Assertions.assertEquals(List.of(), calculReseauService.calculImpactReseau(new CalculEquipementPhysique()));

        Assertions.assertEquals(List.of(), calculReseauService.calculImpactReseau(mapper.readValue("""
                { "equipementPhysique": {} }
                """, CalculEquipementPhysique.class)));

        Assertions.assertEquals(List.of(), calculReseauService.calculImpactReseau(mapper.readValue("""
                {
                    "equipementPhysique": {
                       "goTelecharge": null
                    }
                }
                """, CalculEquipementPhysique.class)));
    }

}