package org.mte.numecoeval.referentiel.infrastructure.init;

import jakarta.annotation.PostConstruct;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.mte.numecoeval.referentiel.domain.exception.ReferentielException;
import org.mte.numecoeval.referentiel.infrastructure.jpa.adapter.ImpactEquipementJpaAdapter;
import org.mte.numecoeval.referentiel.infrastructure.jpa.adapter.ImpactReseauJpaAdapter;
import org.mte.numecoeval.referentiel.infrastructure.jpa.adapter.MixElectriqueJpaAdapter;
import org.mte.numecoeval.referentiel.infrastructure.jpa.repository.ImpactEquipementRepository;
import org.mte.numecoeval.referentiel.infrastructure.jpa.repository.ImpactReseauRepository;
import org.mte.numecoeval.referentiel.infrastructure.jpa.repository.MixElectriqueRepository;
import org.mte.numecoeval.referentiel.infrastructure.mapper.ImpactEquipementMapper;
import org.mte.numecoeval.referentiel.infrastructure.mapper.ImpactReseauMapper;
import org.mte.numecoeval.referentiel.infrastructure.mapper.MixElectriqueMapper;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@AllArgsConstructor
public class FusionFacteurCaracterisationService {
    private MixElectriqueJpaAdapter mixElectriqueJpaAdapter;
    private MixElectriqueRepository mixElectriqueRepository;
    private MixElectriqueMapper mixElectriqueMapper;
    private ImpactReseauJpaAdapter impactReseauJpaAdapter;
    private ImpactReseauRepository impactReseauRepository;
    private ImpactReseauMapper impactReseauMapper;
    private ImpactEquipementJpaAdapter impactEquipementJpaAdapter;
    private ImpactEquipementRepository impactEquipementRepository;
    private ImpactEquipementMapper impactEquipementMapper;

    @PostConstruct
    public void init() throws ReferentielException {
        log.info("démarrage de la fusion des tables vers ref_facteurcaracterisation");

        var mixelecs = mixElectriqueRepository.findAll();
        if (!mixelecs.isEmpty()) {
            log.info("migration des mix électriques vers la nouvelle table");
            mixElectriqueJpaAdapter.saveAll(mixElectriqueMapper.toDomains(mixelecs));
            mixElectriqueRepository.deleteAll();
            log.info("fin de la migration des mix électriques vers la nouvelle table");
        }
        var impactReseaux = impactReseauRepository.findAll();
        if (!impactReseaux.isEmpty()) {
            log.info("migration des impact réseaux vers la nouvelle table");
            impactReseauJpaAdapter.saveAll(impactReseauMapper.toDomains(impactReseaux));
            impactReseauRepository.deleteAll();
            log.info("fin de la migration des impact réseaux vers la nouvelle table");
        }
        var impactEquipements = impactEquipementRepository.findAll();
        if (!impactEquipements.isEmpty()) {
            log.info("migration des impacts équipements vers la nouvelle table");
            impactEquipementJpaAdapter.saveAll(impactEquipementMapper.toDomains(impactEquipements));
            impactEquipementRepository.deleteAll();
            log.info("fin de la migration des impacts équipements vers la nouvelle table");
        }
    }
}
