/* global Descartes, ol, coucheGeosignal, bounds_2154,groupeFonds, groupeRisques, coucheParcs, coucheBati */
var olMap;
var coucheGeo, coucheParc, coucheTerrain, panPanel;
var load = function () {
	
    Descartes.Log.setLevel('debug');

    coucheGeo = new Descartes.Layer.WMS(coucheGeosignal.title, coucheGeosignal.definition, coucheGeosignal.options);
    coucheParc = new Descartes.Layer.WMS(coucheParcs.title, coucheParcs.definition, coucheParcs.options);
    coucheTerrains = new Descartes.Layer.WMS(coucheTerrain.title, coucheTerrain.definition, coucheTerrain.options);
    coucheFailles = new Descartes.Layer.WMS(coucheFailles.title, coucheFailles.definition, coucheFailles.options);
    coucheCommunes = new Descartes.Layer.WMS(coucheCommunes.title, coucheCommunes.definition, coucheCommunes.options);

    var contenuCarte = new Descartes.MapContent({
        editable: true,
        editInitialItems: false,
        fixedDisplayOrders: false,
        fctQueryable: true,
        fctVisibility: true,
        fctOpacity: true,
        displayIconLoading: true,
        fctContextMenu: false,
        fctDisplayLegend: true,
        displayMoreInfos: true
    });

    projection = new Descartes.Projection('EPSG:2154');

    var mapOptions = {
        units: 'm',
        projection: projection,
        initExtent: bounds_2154,
        maxExtent: bounds_2154,
        //maxResolution: 255,
		minScale:500000,
		maxScale:100,
        autoSize: true,
        displayExtendedOLExtent: true
    };

    carte = new Descartes.Map.ContinuousScalesMap('map', contenuCarte, mapOptions);

    manager = carte.addContentManager("layersTree");

    
    contenuCarte.addItem(coucheStations);
    contenuCarte.addItem(coucheBati);
    //contenuCarte.addItem(coucheFailles);
    gpRisques = contenuCarte.addItem(new Descartes.Group(groupeRisques.title, groupeRisques.options));
    var d_coucheTerrain = contenuCarte.addItem(coucheTerrains, gpRisques);
    //contenuCarte.addItem(coucheParc);
    contenuCarte.addItem(coucheCommunes);
    var gpFonds = contenuCarte.addItem(new Descartes.Group(groupeFonds.title, groupeFonds.options));
    contenuCarte.addItem(coucheGeo, gpFonds);

    carte.show();

    var label = true;
    var collapsible = true;
    var collapsed = false;

    var actions = [{
            type: "ScaleSelector",
            div: 'ScaleSelector',
            options: {
                label: label,
                optionsPanel: {
                    collapsible: collapsible,
                    collapsed: collapsed
                }
            }
        }, {
            type: Descartes.Action.InkMapParamsManager,
            div: 'Pdf',
            options: {
                label: label,
                optionsPanel: {
                    collapsible: collapsible,
                    collapsed: collapsed
                },
                params: {
                  displayProjections: ["EPSG:2154","EPSG:4326"],
                  //selectedDisplayProjectionIndex:0
                }
            }
        }
    ];

    carte.addActions(actions);

    //TOOLBAR
    var principalesTools = [
        //{type: Descartes.Map.DRAG_PAN},
        {type: Descartes.Button.InkMapExportPNG},
    ];
    var toolsBar = carte.addNamedToolBar("toolbar", principalesTools);

    //DIRECTIONPANPANEL
    panPanel = carte.addDirectionalPanPanel({duration: 500});

    carte.addMiniMap("http://mapdmz.brgm.fr/cgi-bin/mapserv?map=/carto/infoterre/mapFiles/geocat_metr.map&LAYERS=raster_geosignal", {open: false, version: '1.1.1'});

    carte.addOpenLayersInteractions([
        {type: Descartes.Map.OL_DRAG_PAN, args:{condition:ol.events.condition.noModifierKeys}},
        {type: Descartes.Map.OL_MOUSE_WHEEL_ZOOM}]);

};
