var load = function () {
	
    Descartes.Log.setLevel('debug');

    var projection = new Descartes.Projection('EPSG:3857');

    //add WMTS
    var projectionExtent = projection.getExtent();
    var tileSize = 256;
    var size = ol.extent.getWidth(projectionExtent) / tileSize;
    var origin = ol.extent.getTopLeft(projectionExtent);
    var resolutions = new Array(14);
    var matrixIds = new Array(14);
    for (var z = 0; z < 14; ++z) {
        // generate resolutions and matrixIds arrays for this WMTS
        resolutions[z] = size / Math.pow(2, z);
        matrixIds[z] = z;
    }
    var coucheWMTS = new Descartes.Layer.WMTS('Population USA', [{
        serverUrl: 'https://services.arcgisonline.com/arcgis/rest/services/Demographics/USA_Population_Density/MapServer/WMTS/',
        layerName: '0',
    }],{
        extent: [-13394213.340468, 3771708.723704, -6834081.824921, 6036690.745850],
        matrixSet: "EPSG:3857",
        projection: projection,
        matrixIds: matrixIds,
        origin: origin,
        resolutions: resolutions,
        tileSize: [256, 256],
        format: 'image/png',
        visible: true,
        opacity: 50
    });

    //WMTS works in browser but returns 403 Forbidden in client
    // var coucheWMTS = new Descartes.Layer.WMTS('Orthophotos', [{
    //     serverUrl: 'https://geobretagne.fr/geoportail/wmts',
    //     layerName: 'ORTHOIMAGERY.ORTHOPHOTOS',
    //     layerStyles: "normal"
    // }],{
    //     extent: [-513656.830076, 5963311.198696, -190786.822600, 6269059.311837],
    //     matrixSet: "PM",
    //     projection: projection,
    //     matrixIds: matrixIds,
    //     origin: origin,
    //     resolutions: resolutions,
    //     tileSize: [256, 256],
    //     format: 'image/jpeg',
    //     visible: true,
    //     opacity: 100
    // });

    //WMTS displays, but does not print
    // var resolutions = new Array(20);
    // var matrixIds = new Array(20);
    // for (var z = 0; z < 20; ++z) {
    //     // generate resolutions and matrixIds arrays for this WMTS
    //     resolutions[z] = size / Math.pow(2, z);
    //     matrixIds[z] = "EPSG:3857:" + z;
    // }
    // var coucheWMTS = new Descartes.Layer.WMTS('Carte IGN', [{
    //     serverUrl: 'http://tile.geobretagne.fr/gwc02/service/wmts',
    //     layerName: 'carte'
    // }],{
    //     extent: [-513656.830076, 5963311.198696, -190786.822600, 6269059.311837],
    //     matrixSet: "EPSG:3857",
    //     projection: projection,
    //     matrixIds: matrixIds,
    //     origin: origin,
    //     resolutions: resolutions,
    //     tileSize: [256, 256],
    //     format: 'image/jpeg',
    //     visible: true,
    //     opacity: 100
    // });

    var contenuCarte = new Descartes.MapContent({
        editable: true,
        editInitialItems: false,
        fixedDisplayOrders: false,
        fctQueryable: true,
        fctVisibility: true,
        fctOpacity: true,
        displayIconLoading: true,
        fctContextMenu: false,
        fctDisplayLegend: true,
        displayMoreInfos: true
    });

    var extent3857US = [-13394213.340468, 3771708.723704, -6834081.824921, 6036690.745850];
    // var extent3857Bretagne = [-513656.830076, 5963311.198696, -190786.822600, 6269059.311837];
    var mapOptions = {
        units: 'm',
        projection: projection,
        initExtent: extent3857US,
        maxExtent: extent3857US,
        autoSize: true
    };

    carte = new Descartes.Map.ContinuousScalesMap('map', contenuCarte, mapOptions);

    manager = carte.addContentManager("layersTree");

    
    contenuCarte.addItem(coucheWMTS);

    carte.show();

    var label = true;
    var collapsible = true;
    var collapsed = false;

    var actions = [{
            type: "ScaleSelector",
            div: 'ScaleSelector',
            options: {
                label: label,
                optionsPanel: {
                    collapsible: collapsible,
                    collapsed: collapsed
                }
            }
        }, {
            type: Descartes.Action.InkMapParamsManager,
            div: 'Pdf',
            options: {
                label: label,
                optionsPanel: {
                    collapsible: collapsible,
                    collapsed: collapsed
                },
                params: {
                    displayProjections: ["EPSG:3857","EPSG:2154","EPSG:4326"]
                }
            }
        }
    ];

    carte.addActions(actions);

    //TOOLBAR
    var principalesTools = [
        {type: Descartes.Map.DRAG_PAN},
        {type: Descartes.Button.InkMapExportPNG},
    ];
    carte.addNamedToolBar("toolbar", principalesTools);

    //DIRECTIONPANPANEL
    panPanel = carte.addDirectionalPanPanel({duration: 500});

    carte.addMiniMap("http://mapdmz.brgm.fr/cgi-bin/mapserv?map=/carto/infoterre/mapFiles/geocat_metr.map&LAYERS=raster_geosignal", {open: false, version: '1.1.1'});

    carte.addOpenLayersInteractions([
        {type: Descartes.Map.OL_DRAG_PAN, args:{condition:ol.events.condition.noModifierKeys}},
        {type: Descartes.Map.OL_MOUSE_WHEEL_ZOOM}]);

};
