proj4.defs('EPSG:2154', "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");

var load = function () {
	
	coucheAnnotations = new Descartes.Layer.EditionLayer.Annotations("Couche Annotations");
	coucheGeo = new Descartes.Layer.WMS(coucheGeosignal.title, coucheGeosignal.definition, coucheGeosignal.options);
    coucheParc = new Descartes.Layer.WMS(coucheParcs.title, coucheParcs.definition, coucheParcs.options);
    coucheTerrains = new Descartes.Layer.WMS(coucheTerrain.title, coucheTerrain.definition, coucheTerrain.options);
    coucheFailles = new Descartes.Layer.WMS(coucheFailles.title, coucheFailles.definition, coucheFailles.options);
    coucheCommunes = new Descartes.Layer.WMS(coucheCommunes.title, coucheCommunes.definition, coucheCommunes.options);
	
    Descartes.Log.setLevel('debug');

    Descartes.EditionManager.configure({
        globalEditionMode: false
    });

	var contenuCarte = new Descartes.MapContent({editable: true});
	
	contenuCarte.addItem(coucheAnnotations);
    contenuCarte.addItem(coucheStations);
    contenuCarte.addItem(coucheBati);
    //contenuCarte.addItem(coucheFailles);
    gpRisques = contenuCarte.addItem(new Descartes.Group(groupeRisques.title, groupeRisques.options));
    var d_coucheTerrain = contenuCarte.addItem(coucheTerrains, gpRisques);
    //contenuCarte.addItem(coucheParc);
    contenuCarte.addItem(coucheCommunes);
    var gpFonds = contenuCarte.addItem(new Descartes.Group(groupeFonds.title, groupeFonds.options));
    contenuCarte.addItem(coucheGeo, gpFonds);
    
	var bounds = [799205.2, 6215857.5, 1078390.1, 6452614.0];
    var projection = 'EPSG:2154';
    // Construction de la carte
	var carte = new Descartes.Map.ContinuousScalesMap(
				'map',
				contenuCarte,
				{
					projection: projection,
					initExtent: bounds,
					maxExtent: bounds,
					minScale:2150000,
					maxScale:100,
					autoSize: true
				}
			);
	
	//var toolsBar = carte.addNamedToolBar('toolBar');
	//carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.DRAG_PAN});
	//carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.ZOOM_IN});
	//carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.ZOOM_OUT});
	/*carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.INITIAL_EXTENT, args : bounds});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.MAXIMAL_EXTENT});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.CENTER_MAP});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.COORDS_CENTER});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.NAV_HISTORY});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.DISTANCE_MEASURE});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.AREA_MEASURE});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.POINT_SELECTION});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.POLYGON_SELECTION});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.RECTANGLE_SELECTION});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.CIRCLE_SELECTION});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.POINT_RADIUS_SELECTION});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.PNG_EXPORT});
	carte.addToolInNamedToolBar(toolsBar,{type : Descartes.Map.PDF_EXPORT});*/
    /*var toolsBar = carte.addAnnotationToolBar('toolBar', [{
               type: Descartes.Map.EDITION_DRAW_ANNOTATION,
               args: {
                   geometryType: Descartes.Tool.Edition.ANNOTATION_RECTANGLE_GEOMETRY,
                   snapping: true
               }
           }], {});*/
           
    var toolsBar1 = carte.addToolBar("toolBar", [
		            {
              type: Descartes.Map.DISTANCE_MEASURE,
            },{
              type: Descartes.Map.SHARE_LINK_MAP,
            }]);
    carte.addAnnotationToolBar("null", [{
			         type : Descartes.Map.TOOLBAR_OPENER, 
				     args : { 
						displayClass: 'editionOpenerButton',
						title: "Outils d'annotations",
						tools: [
							{
				               type: Descartes.Map.EDITION_AIDE_ANNOTATION
				           },{
               type: Descartes.Map.EDITION_DRAW_ANNOTATION,
               args: {
                   geometryType: Descartes.Layer.POINT_GEOMETRY,
                   snapping: true
               }
           },{
               type: Descartes.Map.EDITION_DRAW_ANNOTATION,
               args: {
                   geometryType: Descartes.Layer.LINE_GEOMETRY,
                   snapping: true,
                   autotracing: true
               }
           },{
               type: Descartes.Map.EDITION_DRAW_ANNOTATION,
               args: {
                   geometryType: Descartes.Layer.POLYGON_GEOMETRY,
                   snapping: true,
                   autotracing: true
               }
           },{
               type: Descartes.Map.EDITION_DRAW_ANNOTATION,
               args: {
                   geometryType: Descartes.Tool.Edition.ANNOTATION_RECTANGLE_GEOMETRY,
                   snapping: true
               }
           }, {
               type: Descartes.Map.EDITION_DRAW_ANNOTATION,
               args: {
                   geometryType: Descartes.Tool.Edition.ANNOTATION_CIRCLE_GEOMETRY,
                   snapping: true
               }
           }, {
               type: Descartes.Map.EDITION_ARROW_ANNOTATION,
               args: {
                   snapping: true
               }
           }, {
               type: Descartes.Map.EDITION_FREEHAND_ANNOTATION,
               args: {
                   snapping: true
               }
           }, {
               type: Descartes.Map.EDITION_TEXT_ANNOTATION,
               args: {
                   snapping: true
               }
           }, {
				               type: Descartes.Map.EDITION_BUFFER_HALO_ANNOTATION
				           }, {
               type: Descartes.Map.EDITION_GLOBAL_MODIFICATION_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_VERTICE_MODIFICATION_ANNOTATION,
               args: {
                   snapping: true
               }
				           },
				           {
               type: Descartes.Map.EDITION_ADD_TEXT_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_ATTRIBUTE_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_STYLE_ANNOTATION
           }, {
				               type: Descartes.Map.EDITION_SNAPPING_ANNOTATION
				           }, {
               type: Descartes.Map.EDITION_RUBBER_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_ERASE_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_EXPORT_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_IMPORT_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_GEOLOCATION_SIMPLE_ANNOTATION
           }, {
               type: Descartes.Map.EDITION_GEOLOCATION_TRACKING_ANNOTATION
           }
       ],
						toolBarOptions: {
							panel:true,
							draggable: {
			                    enable: true,
			                    containment: 'parent'
			                },
			                resizable:true
			            }
					}
			},
          ],
       {
    	   toolBar: toolsBar1,// barre d'outils d'édition imbriquée dans la barre principale
   	      // openerTool: true
   	   } 
    );


	carte.addContentManager(
		'layersTree',
		[
			{type : Descartes.Action.MapContentManager.ADD_GROUP_TOOL},
			{type : Descartes.Action.MapContentManager.ADD_LAYER_TOOL},
			{type : Descartes.Action.MapContentManager.REMOVE_GROUP_TOOL},
			{type : Descartes.Action.MapContentManager.REMOVE_LAYER_TOOL},
			{type : Descartes.Action.MapContentManager.ALTER_GROUP_TOOL},
			{type : Descartes.Action.MapContentManager.ALTER_LAYER_TOOL},
			{type : Descartes.Action.MapContentManager.ADD_WMS_LAYERS_TOOL},
			{type : Descartes.Action.MapContentManager.EXPORT_VECTORLAYER_TOOL}
		],
		{
			toolBarDiv: "managerToolBar"
		}
	);
    carte.show();

	// Ajout des zones informatives
	carte.addInfo({type : Descartes.Map.GRAPHIC_SCALE_INFO, div : null});
	carte.addInfo({type : Descartes.Map.MOUSE_POSITION_INFO, div : 'LocalizedMousePosition'});
	carte.addInfo({type : Descartes.Map.METRIC_SCALE_INFO, div : 'MetricScale'});
	carte.addInfo({type : Descartes.Map.MAP_DIMENSIONS_INFO, div : 'MapDimensions'});
	carte.addInfo({type : Descartes.Map.LEGEND_INFO, div : 'Legend' ,options: {
                    displayLayerTitle: true
                }});
	carte.addInfo({type : Descartes.Map.ATTRIBUTION_INFO, div : null});
	

	// Ajout des assistants
	carte.addAction({type : Descartes.Map.SCALE_SELECTOR_ACTION, div : 'ScaleSelector'});
	carte.addAction({type : Descartes.Map.SCALE_CHOOSER_ACTION, div : 'ScaleChooser'});
//	carte.addAction({type : Descartes.Map.SIZE_SELECTOR_ACTION, div : 'SizeSelector'});
	carte.addAction({type : Descartes.Map.COORDS_INPUT_ACTION, div : 'CoordinatesInput'});
	carte.addAction({type : Descartes.Action.InkMapParamsManager, div : 'Pdf',
            options: {
                params: {
                    displayProjections: ["EPSG:2154","EPSG:4326"]
                }
            }});
	
	// Ajout de la rose des vents
	carte.addDirectionalPanPanel();

	// Ajout de la minicarte
	carte.addMiniMap("https://carto2.geo-ide.din.developpement-durable.gouv.fr/rest-api/ows/22c7124f-8453-4535-b735-555f03d2c88d?LAYERS=c_natural_Valeurs_type");
	
	// Ajout du gestionnaire de requete
	var gestionnaireRequetes = carte.addRequestManager('Requetes');
	var requeteBati = new Descartes.Request(coucheBati, "Filtrer les constructions", Descartes.Layer.POLYGON_GEOMETRY);
	var critereType = new Descartes.RequestMember(
					"Sélectionner le type",
					"type",
					"==",
					["chateau", "batiment public", "ecole", "eglise"],
					true
				);
	
	requeteBati.addMember(critereType);
	gestionnaireRequetes.addRequest(requeteBati);
	
	// Ajout du gestionnaire d'info-bulle
	/*carte.addToolTip('ToolTip', [
  		{layer: coucheParkings, fields: ['Nom']},
  		{layer: coucheStations, fields: ['Nom']}
  	]);*/
  	
  	/*carte.addToolTip('ToolTip', [ // pour intranet
   		{layer: coucheParkings, fields: ['name']},
   		{layer: coucheStations, fields: ['name']}
   	]);*/

	
	// Ajout du gestionnaire de contextes
	carte.addBookmarksManager('Bookmarks', 'exemple-descartes',{behavior : Descartes.Action.BookmarksManager.BEHAVIOR_MANAGED_BY_CREATOR});
	
	// Ajout du gestionnaire de localisation rapide
	carte.addDefaultGazetteer('Gazetteer', "93", Descartes.Action.DefaultGazetteer.DEPARTEMENT);
	
    carte.addOpenLayersInteractions([
        {type: Descartes.Map.OL_DRAG_PAN, args:{condition:ol.events.condition.noModifierKeys}},
        {type: Descartes.Map.OL_MOUSE_WHEEL_ZOOM}]);

};
