export type Body_login_login_access_token = {
  grant_type?: string | null
  username: string
  password: string
  scope?: string
  client_id?: string | null
  client_secret?: string | null
}

export type HTTPValidationError = {
  detail?: Array<ValidationError>
}

export type CollectionCreate = {
  title: string
  description?: string | null
  type: string
}

export type CollectionPublic = {
  title: string
  description?: string | null
  type: string
  id: string
  owner: string
  can_edit: boolean
}

export type CollectionUpdate = {
  title?: string | null
  description?: string | null
}

export type CollectionsPublic = {
  items: Array<CollectionPublic>
  total: number
  pages: number
}

export type Message = {
  message: string
}

export type NewPassword = {
  token: string
  new_password: string
}

export type Token = {
  access_token: string
  token_type?: string
}

export type UpdatePassword = {
  current_password: string
  new_password: string
}

export type UserCreate = {
  email: string
  is_active?: boolean
  role?: string
  full_name?: string | null
  password: string
  group_id: number
}

export type UserPublic = {
  email: string
  is_active?: boolean
  role?: string
  full_name?: string | null
  id: string
  group_id: number
}

export type UserRegister = {
  email: string
  password: string
  full_name?: string | null
}

export type UserUpdate = {
  email?: string | null
  is_active?: boolean
  role?: string
  full_name?: string | null
  password?: string | null
  group_id?: number | null
}

export type UserUpdateMe = {
  full_name?: string | null
  email?: string | null
}

export type UsersPublic = {
  items: Array<UserPublic>
  total: number
  pages: number
}

export type ValidationError = {
  loc: Array<string | number>
  msg: string
  type: string
}
