from typing import cast

from sqlmodel import Session

from app import crud
from app.models import Collection, CollectionCreate
from app.tests.utils.user import create_random_user
from app.tests.utils.utils import random_lower_string


def create_random_collection(db: Session) -> Collection:
    user = create_random_user(db)
    user_id = user.id
    assert user_id is not None
    title = random_lower_string()
    description = random_lower_string()
    collection_in = CollectionCreate(title=title, description=description)
    return cast(
        Collection,
        crud.create_generic_item(
            session=db,
            model=Collection,
            item=collection_in,
            user_id=user_id,
            group_id=user.group_id,
        ),
    )
