from fastapi.testclient import TestClient

from app.core.config import settings


def test_create_group(client: TestClient, superuser_token_headers: dict[str, str]) -> None:
    data = {"name": "Test", "domain": "test.com"}
    response = client.post(f"{settings.API_V1_STR}/groups/", headers=superuser_token_headers, json=data)
    assert response.status_code == 200, response.text
    content = response.json()
    assert content["name"] == "Test"
    assert content["domain"] == "test.com"
    assert "id" in content
