from cloudpathlib import S3Client

from app.core.config import settings

protocol = "https" if settings.S3_IS_ENDPOINT_SECURE else "http"
if not settings.S3_ENDPOINT.startswith(protocol):
    endpoint_url = f"{protocol}://{settings.S3_ENDPOINT}"
else:
    endpoint_url = settings.S3_ENDPOINT

client = S3Client(
    endpoint_url=endpoint_url,
    aws_access_key_id=settings.S3_ACCESS_KEY,
    aws_secret_access_key=settings.S3_SECRET_KEY,
    aws_session_token=settings.S3_SESSION_TOKEN,
)

COLLECTIONS_BUCKET_NAME = settings.S3_COLLECTIONS_BUCKET_NAME
