/**
 * This helper function encapsulates the logic to process and handle SSE event-streams
 * @param response
 * @param processCallback
 * @param doneCallback
 * @param separator
 */
const handleSSE = async (
  response: Response,
  processCallback: (currentEvent: any) => void,
  doneCallback: () => void,
  separator: string = "\n"
) => {
  if (response.body) {
    const reader = response.body.getReader();
    const decoder = new TextDecoder("utf-8");
    // Sometimes json sended by the server is cut in chunk
    // So we have to recreate the entire JSON manually
    let incompleteJson = "";

    // As long as there is data returned by the stream, we process the incoming messages
    while (true) {
      const { value, done } = await reader.read();
      const currentEventStr = decoder.decode(value);
      if (done) {
        doneCallback();
        break;
      }

      // Since we receive JSON data, we need to parse it to exploit it
      try {
        const strToParse = incompleteJson
          ? incompleteJson + currentEventStr
          : currentEventStr;
        // It seems events sometime arrives together as being buffered
        const currentEvents = strToParse
          .split(separator)
          .filter((eventStr) => eventStr);
        for (let currentEventStr of currentEvents) {
          try {
            const currentEvent = JSON.parse(currentEventStr);
            processCallback(currentEvent);
            incompleteJson = "";
          } catch (e) {
            console.error("Parsing incomplete JSON", e);
            incompleteJson = currentEventStr;
          }
        }
      } catch (e) {
        console.error(e);
        throw new Error("La traitement de la réponse a échoué.");
      }
    }
  } else {
    throw new Error("La génération de réponse a échoué.");
  }
};

export { handleSSE };
