import React, { useEffect, useState, useContext, createContext } from "react";
import { Navigate, useLocation } from "react-router-dom";

import { AuthContext } from "./AuthProvider";

type ProtectedRouteProps = {
  children: React.ReactNode;
};

const ProtectedRoute: React.FC<ProtectedRouteProps> = ({ children }) => {

  const { isAuthenticated, isLoading } = useContext(AuthContext);

  if (isLoading) {
    return <div>Vérification de votre identité...</div>;
  }

  if (!isAuthenticated) {
    // Keep the query string since SSO error may be in it
    return <Navigate to={`/login${location.search}`} replace />;
  }

  return <>{children}</>;
};

export default ProtectedRoute;
