import { useMemo } from "react";
import { useDropzone } from "react-dropzone";
import { fr } from "@codegouvfr/react-dsfr";

export function DropZone({ onDrop }: { onDrop: (fileList: File[]) => void }) {
  const baseStyle = {
    marginLeft: "1rem",
    marginRight: "1rem",
    marginBottom: "1rem",
    alignItems: "center",
    padding: "20px",
    borderWidth: 2,
    borderRadius: 2,
    borderColor: fr.colors.decisions.border.default.grey.default,
    borderStyle: "dashed",
    backgroundColor: fr.colors.decisions.background.default.grey.default,
    color: fr.colors.decisions.text.default.grey.default,
    outline: "none",
    transition: "border .24s ease-in-out",
  };

  const focusedStyle = {
    borderColor: fr.colors.decisions.text.default.info.default,
  };

  const acceptStyle = {
    borderColor: fr.colors.decisions.text.default.success.default,
  };

  const rejectStyle = {
    borderColor: fr.colors.decisions.text.default.error.default,
  };

  const { getRootProps, getInputProps, isFocused, isDragAccept, isDragReject } =
    useDropzone({
      accept: { "application/pdf": [".pdf"] },
      onDrop: (files) => {
        onDrop(files);
      },
    });

  const style = useMemo(
    () => ({
      ...baseStyle,
      ...(isFocused ? focusedStyle : {}),
      ...(isDragAccept ? acceptStyle : {}),
      ...(isDragReject ? rejectStyle : {}),
    }),
    [isFocused, isDragAccept, isDragReject]
  );

  return (
    <section>
      <div {...getRootProps({ style })}>
        <input {...getInputProps()} />
        <p>Déposez des fichiers ici</p>
      </div>
    </section>
  );
}
