import CircularProgress from "@mui/material/CircularProgress";
import Box from "@mui/material/Box";
import Typography from "@mui/material/Typography";
import { ReactNode } from "react";

// Wasn't able to reproduce positionning from material ui doc : https://mui.com/material-ui/react-progress/#interactive-integration
// So I took inspiration from : https://stackoverflow.com/a/63143759
export default function CircularProgressWithContent({
  content,
}: {
  content: ReactNode;
}) {
  return (
    <Box position="relative" display="inline-flex">
      <CircularProgress size={26} color="info"/>
      <Box
        top={9}
        left={0}
        bottom={0}
        right={0}
        position="absolute"
        display="flex"
        alignItems="center"
        justifyContent="center"
      >
        <Typography variant="caption" component="div" color="textSecondary">
          {content}
        </Typography>
      </Box>
    </Box>
  );
}
