import { useContext, useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";
import { fr } from "@codegouvfr/react-dsfr";
import { cx } from "@codegouvfr/react-dsfr/tools/cx";
import { Notice } from "@codegouvfr/react-dsfr/Notice";
import { ProConnectButton } from "@codegouvfr/react-dsfr/ProConnectButton";
import { forgeUrl } from "./shared/fetchUtils";

import { AuthContext } from "@/components/AuthProvider";
import { LoginForm } from "./LoginForm";

export function LoginPage() {
  console.log("log", import.meta.env.VITE_ALLOW_LOGIN_FORM);
  const { isAuthenticated } = useContext(AuthContext);
  const navigate = useNavigate();

  useEffect(() => {
    if (isAuthenticated) {
      navigate("/");
    }
  }, [isAuthenticated]);

  return (
    <div
      className={cx(
        fr.cx("fr-container"),
        fr.cx("fr-pl-32v"),
        fr.cx("fr-pt-10v")
      )}
    >
      {window.location.search.includes("error") && (
        <Notice
          isClosable={false}
          title="Une erreur est survenu pendant la connexion via SSO"
        />
      )}
      <Notice title="Merci de vous identifier afin de pouvoir utiliser nos services." />

      {import.meta.env.VITE_ALLOW_LOGIN_FORM && (
        <>
          <LoginForm /> <div className="fr-container">Ou bien</div>
        </>
      )}

      <ProConnectButton
        url={
          forgeUrl(
            `/login/sso?redirect_url=${encodeURIComponent(
              window.location.origin
            )}`
          ) + "/"
        }
      />
    </div>
  );
}
