import { useContext, useState } from "react";
import { fr } from "@codegouvfr/react-dsfr";

//import PdfViewerComponent from "@/components/PdfViewerComponent";
import { Document, Page, pdfjs } from "react-pdf";

pdfjs.GlobalWorkerOptions.workerSrc = `//unpkg.com/pdfjs-dist@${pdfjs.version}/build/pdf.worker.min.mjs`;

import ViewerSidePanel from "@/components/ViewerSidePanel";
import { LiriaeDocument } from "@/shared/types";

export function Home() {
  const [numPages, setNumPages] = useState<number>(0);
  const [pageNumber, setPageNumber] = useState<number>(1);
  const [currentDocument, setCurrentDocument] = useState<LiriaeDocument | null>(
    null
  );

  const onDocumentSelected = (document: LiriaeDocument | null) => {
    setCurrentDocument(document);
  };

  function onDocumentLoadSuccess({ numPages }: { numPages: number }): void {
    setNumPages(numPages);
    setPageNumber(1);
  }

  function changePage(offset: number) {
    setPageNumber((prevPageNumber) => prevPageNumber + offset);
  }

  function previousPage() {
    changePage(-1);
  }

  function nextPage() {
    changePage(1);
  }

  const currentPath =
    currentDocument &&
    `${import.meta.env.VITE_API_URL}/file/${currentDocument.id}`;
  return (
    <>
      <div className={fr.cx("fr-container")}>
        <div className={fr.cx("fr-grid-row")}>
          <div className={fr.cx("fr-col-3")}>
            <ViewerSidePanel
              selectedDocument={currentDocument}
              onSelection={onDocumentSelected}
            />
          </div>
          <div className={fr.cx("fr-col-9")}>
            <p>
              <p>
                Page {pageNumber || (numPages ? 1 : "--")} of {numPages || "--"}
              </p>
              <button
                type="button"
                disabled={pageNumber <= 1}
                onClick={previousPage}
              >
                Previous
              </button>
              <button
                type="button"
                disabled={pageNumber >= numPages}
                onClick={nextPage}
              >
                Next
              </button>
            </p>
            <Document file={currentPath} onLoadSuccess={onDocumentLoadSuccess}>
              <Page
                pageNumber={pageNumber}
                renderTextLayer={false}
                renderAnnotationLayer={false}
              />
            </Document>
          </div>
        </div>
      </div>
    </>
  );
}
