# LIRIAe - PDF

Projet de visualisation, d'annotation et d'analyse de pdf pour le ministère de la transition écologique.

Le projet est pour l'instant constitué d'un backend commun a d'autre projet sofia ([sofia-collections](https://gitlab.com/ademe-group/sofia/sofia-collections)) écrit en Python avec FastAPI et un frontend écrit en React avec la librairie react-dsfr.


Frontend de l'application LIRIAe-PDF créé à partir de [l'appli démo utilisant vite et react-dsfr](https://github.com/garronej/react-dsfr-vite-demo)

### Lancer le front

Le frontend, développé en React, utilise l'utilitaire `yarn` ([instructions pour son installation](https://yarnpkg.com/getting-started/install)) qui dépend lui-même de Node.js ([instruction pour l'installation de Node.js](https://nodejs.org/fr/learn/getting-started/how-to-install-nodejs)).

Il faut d'abord installer les dépendances du front.

```bash
yarn install
# Étape nécessaire après l'installation de pspdfkit
# Voir https://www.nutrient.io/getting-started/web/?frontend=react&project=existing-project#adding-pspdfkit-to-your-project
cp -R ./node_modules/pspdfkit/dist/pspdfkit-lib public/pspdfkit-lib
```

Ensuite copier le fichier `.env.sample` dans `.env` :

```
cp .env.sample .env
```

Note : Ce fichier contient une seule variable d'environnement `VITE_API_URL` qui est l'url back que doit atteindre le front pour faire ces requêtes.
Normalement vous n'avez pas à la modifier.

Puis lancer le serveur de développement qui vous permettra de recharger automatiquement la page lors de modifications du code :

`yarn dev`

## Déployer sur le sspcloud

- Créer un service "vscode-python" avec comme port 5174 par exemple
- Ouvrir vscode et le terminal

```console
git clone https://gitlab.com/ademe-group/sofia/liriae_viewer.git
# Install nvm
curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.40.1/install.sh | bash
source /home/onyxia/.bashrc
# Install node
nvm install node
# Install Yarn
corepack enable
yarn set version 4.5.1
cd liriae_viewer/
cp .env.sample .env
# Edit .env file and set the sspcloud backend service address and comment VITE_USE_DOCENGINE
yarn install
cp -R ./node_modules/pspdfkit/dist/pspdfkit-lib public/pspdfkit-lib
# Important : don't use localhost
yarn dev --host 0.0.0.0 --port 5174 # Or the port you use when configuring the service
```