
# regroupement des données----------------------------------------------------

ecln_regroup <- bind_rows(ecln_publique,ecln_secret20)


# 4. Calage
# Les Mises en ventes et le stock en fin de trimestre (= Encours) sont calées pour les données du dernier trimestre
# La cale est actuellement uniquement calculées au niveau régional et départemental
# De fait, pour les mises en ventes et les encours, les données à l'EPCI ne seront pas diffusées sur le dernier truimestre mais sur le précédant
# On récupère la cale dans le fichier cale_reg_dep : elle est décomposée par type delogement (id_type_lgt), de construction (id_nature_projet) et type de pièces (typo)
# L'objectif est de calculer pour chaque indicateur devant être calé sa cale pour les différents niveaux géographiquex (france, reg et dep) :
#   - Mises en ventes - Maisons
# - Mises en ventes - Appartements
# - Mises en ventes - Logements
# - Mises en ventes - Construction neuve
# - Mises en ventes - Construction sur existant
# - Encours - Maisons
# - Encours - Appartements
# - Encours - Logements
# - Encours - Construction neuve
# - Encours - Construction sur existant


# 4.1 Calage des indicateurs ventilés par type de logement
# # On transpose (lignes (modalités de typo) en colonnes) la table de calage pour pouvoir sommer
# # la cale (=valeurs de chaque typo) par type de logement
# # on conserve tous les échelons géo pour pouvoir calculer les différents agrégats (nat, reg, dep)

Cale_typ <- cale_reg_dep %>%
  filter(!(reg2 %in% c("01", "02", "03", "04", "05", "06"))) %>%
  select (reg2, dep, id_type_lgt, typo, Periode = trimestre_enquete, cale) %>%
  group_by(Periode, reg2, dep, id_type_lgt, typo) %>%
  summarise(cale_tot = sum(cale), na.rm = T) %>%
  pivot_wider(id_cols =c(Periode, reg2, dep, id_type_lgt),
              names_from = typo,
              values_from = cale_tot) %>%
  mutate(Cale = t1 + t2 + t3 + t4 + t5 + t6,
         Periode = factor(Periode),
         id_type_lgt = factor(id_type_lgt),
         Calage = fct_recode(id_type_lgt,`Cale - Maisons` = "1", `Cale - Appartements` = "2")) %>%
  ungroup() %>%
  select(-id_type_lgt, -c(t1:t6))

Cale_typ_nat <- Cale_typ %>%
  group_by (Periode, Calage) %>%
  summarise(Cale= sum(Cale)) %>%
  mutate(TypeZone = "France",
         TypeZone = factor(TypeZone),
         Periode = factor(Periode),
         CodeZone = "FRMETRO",
         CodeZone = factor(CodeZone))


Cale_typ_reg <- Cale_typ %>%
  group_by (Periode,reg2, Calage) %>%
  summarise(Cale= sum(Cale)) %>%
  mutate( TypeZone = "Régions",
          TypeZone = factor(TypeZone),
          Periode = factor(Periode),
          CodeZone = factor(reg2)) %>%
  ungroup() %>%
  select(-reg2)

Cale_typ_dep <- Cale_typ %>%
  group_by (Periode,dep, Calage) %>%
  summarise(Cale= sum(Cale)) %>%
  mutate( TypeZone = "Départements",
          TypeZone = factor(TypeZone),
          Periode = factor(Periode),
          CodeZone = factor(dep)) %>%
  ungroup() %>%
  select(-dep)


# On empile les tables cela nous permettra de calculer le total
Cale_typ <- bind_rows (Cale_typ_nat, Cale_typ_reg, Cale_typ_dep)

#  On calcule le total pour tout type de logement

Cale_typ_tot <- bind_rows(
  Cale_typ,
  Cale_typ %>%
    mutate(Calage = str_split_fixed(Calage, " - ", 2)[, 1] %>% str_c(" - Logements") %>% as.factor()) %>%
    group_by_if (is.factor) %>%
    summarise_all(funs(sum(., na.rm = T))) %>%
    ungroup()
) %>%
  mutate_if(is.character, as.factor)

# 4.2 Calage pour les indicateurs ventilés par nature du projet
# On transpose (lignes (modalités de typo) en colonnes) la table de calage pour pouvoir sommer
# la cale (=valeurs de chaque typo) par nature du projet
# on conserve tous les échelons géo pour pouvoir calculer les différents agrégats

Cale_cons <- cale_reg_dep %>%
  filter(!(reg2 %in% c("01", "02", "03", "04", "05", "06"))) %>%
  select (reg2, dep, id_nature_projet, typo, Periode = trimestre_enquete, cale) %>%
  group_by(Periode, reg2, dep, id_nature_projet, typo) %>%
  summarise(cale_tot = sum(cale), na.rm = T) %>%
  pivot_wider(id_cols =c(Periode, reg2, dep, id_nature_projet),
              names_from = typo,
              values_from = cale_tot) %>%
  mutate(Cale = t1 + t2 + t3 + t4 + t5 + t6,
         Periode = factor(Periode),
         id_nature_projet = factor(id_nature_projet),
         Calage = fct_recode(id_nature_projet,`Cale - Constructions neuves` = "1", `Cale - Constructions sur existant` = "2")) %>%
  ungroup() %>%
  select(-id_nature_projet,-c(t1:t6))


Cale_cons_nat <- Cale_cons %>%
  group_by (Periode, Calage) %>%
  summarise(Cale= sum(Cale)) %>%
  mutate(TypeZone = "France",
         TypeZone = factor(TypeZone),
         Periode = factor(Periode),
         CodeZone = "FRMETRO",
         CodeZone = factor(CodeZone))


Cale_cons_reg <- Cale_cons %>%
  group_by (Periode,reg2, Calage) %>%
  summarise(Cale= sum(Cale)) %>%
  mutate( TypeZone = "Régions",
          TypeZone = factor(TypeZone),
          Periode = factor(Periode),
          CodeZone = factor(reg2)) %>%
  ungroup() %>%
  select(-reg2)

Cale_cons_dep <- Cale_cons %>%
  group_by (Periode,dep, Calage) %>%
  summarise(Cale= sum(Cale)) %>%
  mutate( TypeZone = "Départements",
          TypeZone = factor(TypeZone),
          Periode = factor(Periode),
          CodeZone = factor(dep))%>%
  ungroup() %>%
  select(-dep)

Cale_cons <- bind_rows (Cale_cons_nat, Cale_cons_reg, Cale_cons_dep)


# 4.3 Calcul des valeurs des indicateurs calés
# A partir de la table des indicateurs à caler

# On empile toutes les tables de calage
cale <- bind_rows (Cale_cons, Cale_typ_tot)

# Liste des indicateurs à caler

# Indic_a_caler <- str_subset(levels(indic_ecln$Indicateur), c("Encours","Mises"))
# Indic_a_caler <- c( str_subset(levels(indic_ecln$Indicateur), "Encours"),  str_subset(levels(indic_ecln$Indicateur), "Mises") )
Indic_a_caler <- c( str_subset(levels(ecln_regroup$Indicateur), "Encours"),  str_subset(levels(ecln_regroup$Indicateur), "Mises") )


ecln_regroup <- ecln_regroup %>%
  mutate(indic_calage = ifelse(TypeZone %in% c("France", "Régions", "Départements") &
                                 Indicateur %in% Indic_a_caler &
                                 Periode == millesime, "oui", "non"))
# Periode == "2023T2", "oui", "non"))


# extraction dans la table des indicateurs ECLN des indicateurs à caler

Indic_cale <- ecln_regroup %>%
  filter(indic_calage == "oui") %>%
  mutate ( Calage = case_when(Indicateur == 'Mises en vente - Appartements' |  Indicateur == 'Encours - Appartements' ~ 'Cale - Appartements',
                              Indicateur == 'Mises en vente - Maisons' | Indicateur == 'Encours - Maisons' ~ 'Cale - Maisons',
                              Indicateur == 'Mises en vente - Constructions neuves' | Indicateur == 'Encours - Constructions neuves' ~ 'Cale - Constructions neuves',
                              Indicateur == 'Mises en vente - Constructions sur existant' | Indicateur == 'Encours - Constructions sur existant' ~ 'Cale - Constructions neuves sur existant',
                              Indicateur == 'Mises en vente - Logements' | Indicateur == 'Encours - Logements' ~ 'Cale - Logements'
  ))


Indic_cale <- Indic_cale %>%
  left_join(cale) %>%
  mutate(Valeur = ifelse(is.na(Cale), Valeur, Valeur + Cale))


# 4.4 Table finale = table des indicateurs à caler + celle des indicateurs non calés

# # On empile la table des indicateurs calés avec la table des indic_non calés


Indic_final <- bind_rows( ecln_regroup %>%
                            filter(indic_calage == "non") ,
                          Indic_cale %>% select (-Cale, -Calage)) %>%
  select(-indic_calage)

rm(cale,Cale_cons,Cale_cons_dep,Cale_cons_nat,Cale_cons_reg,Cale_typ,Cale_typ_dep,
   Cale_typ_nat,Cale_typ_reg,cale_reg_dep,Indic_cale,Indic_a_caler)
rm(ecln_publique,ecln_secret20,Cale_typ_tot,ecln_regroup)
