
#' Definir le theme par defaut des graphiques de la publication
#'
#' @return une fonction
#' @importFrom ggplot2 theme_set theme
#' @importFrom gouvdown theme_gouv
#' @export
#' @examples
#' set_theme()
set_theme <- function() {
  ggplot2::theme_set(gouvdown::theme_gouv(
    base_size = 12,
    strip_text_size = 12,
    plot_title_size = 20,
    subtitle_size = 16
  ) +
    ggplot2::theme(
      legend.position = "bottom",
      plot.caption.position = "plot"
    ))
}
