graphique_synthese <- function(type_logement = "Appartements",
                               titre = "Les ventes d'appartements neufs en Pays de la Loire",
                               sous_titre = "Sur 12 mois glissants",
                               titre_legende_carte = "",
                               ncol_facet = 5,
                               bas_de_page = "") {
  p1 <- carte_volume(
    type_logement = type_logement,
    indicateurs = "Ventes",
    titre = NULL,
    titre_legende = titre_legende_carte,
    bas_de_page = NULL
  )

  p3 <- graphique_investissement_locatif(
    data = indic_ecln %>%
      filter(TypeZone == "Régions"),
    type_logement = type_logement,
    titre = "",
    bas_de_page = NULL
  ) +
    guides(
      colour = F,
      order = 0,
      fill = guide_legend(
        direction = "vertical",
        keyheight = unit(2, units = "mm"),
        nrow = 2
      )
    )
  p4 <- graphique_series_temporelles_prix(
    data = indic_ecln %>%
      filter(TypeZone == "Régions"),
    type_logement = type_logement
  )

  p5 <- graphique_series_temporelles(
    data = indic_ecln %>%
      filter(TypeZone == "Départements"),
    type_logement = type_logement,
    indicateurs = "Ventes",
    ncol_facet = ncol_facet,
    bas_de_page = bas_de_page
  ) +
    theme(legend.position = "none")

  p6 <- graphique_series_temporelles(
    data = indic_ecln %>%
      filter(TypeZone %in% c("France", "Régions")),
    type_logement = type_logement
  )

  labels <- c("Investissement locatif", "Prix de vente au m2")
  if (type_logement == "Maisons") {
    labels <- c("Investissement locatif", "Prix de vente par maison")
  }
  p <- plot_grid(p3, p4, ncol = 1, labels = labels)
  p <- plot_grid(p1, p, ncol = 2, rel_widths = c(2, 1))
  p <- plot_grid(p, p5, ncol = 1, rel_heights = c(2, 1), labels = c("", "Ventes par départements"))
  p <- plot_grid(p6, p, ncol = 1, rel_heights = c(1, 3))

  title <- ggdraw() +
    draw_label(titre,
      fontface = "bold", hjust = .5, size = 20, fontfamily = "Roboto"
    )
  sub_title <- ggdraw() +
    draw_label(sous_titre,
      fontface = "plain", hjust = .5, size = 15, fontfamily = "Roboto"
    )
  p <- plot_grid(title, sub_title, p, ncol = 1, rel_heights = c(.03, .03, 1))
  p
}
