# analyse secrétisation avec zonages
# faire tourner les scripts jusqu'à la 4e ligne du script 4.
# Pour info, la table identique non secrétisée est la la table ecln_00 créée dans le script 2,
# qui comporte le même nombre de lignes.
#  l'analyse se fait sur la tables ecln_regroup dans laquelle on va compter le nombre de NA

library(tidyr)
library(openxlsx)
library(COGiter)

seize_periodes <- ecln_regroup %>%
  select(Periode) %>%
  unique() %>%
  arrange(desc(Periode)) %>%
  head(16) %>%
  pull() %>%
  as.character()


# donnees non secretisees
B <- ecln_regroup %>%
  filter(Periode %in% seize_periodes) %>%
  mutate(CodeZone = forcats::fct_drop(.data$CodeZone),
         Zone = forcats::fct_drop(.data$Zone),
         TypeZone = forcats::fct_drop(.data$TypeZone))

REG_B_par_zone_indic_et_periode <- B %>%
  filter (TypeZone == "Régions") %>%
  select(Zone,Indicateur,Periode,Valeur) %>%
  group_by(Zone,Indicateur,Periode) %>%
  summarise(nb_valeur_ensemble = n())

DEP_B_par_zone_indic_et_periode <- B %>%
  filter (TypeZone == "Départements") %>%
  select(CodeZone,Zone,Indicateur,Periode,Valeur) %>%
  group_by(CodeZone,Zone,Indicateur,Periode) %>%
  summarise(nb_valeur_ensemble = n())

EPCI_B_par_zone_indic_et_periode <- B %>%
  filter (TypeZone == "Epci") %>%
  select(CodeZone,Zone,Indicateur,Periode,Valeur) %>%
  group_by(CodeZone,Zone,Indicateur,Periode) %>%
  summarise(nb_valeur_ensemble = n()) %>%
  ungroup()



# donnees secretisees
A <- ecln_regroup %>%
  filter(Periode %in% seize_periodes) %>%
  filter (is.na(Valeur)) %>%
  mutate(CodeZone = forcats::fct_drop(.data$CodeZone),
         Zone = forcats::fct_drop(.data$Zone),
         TypeZone = forcats::fct_drop(.data$TypeZone))

REG_A_par_zone_indic_et_periode <- A %>%
  filter (TypeZone == "Régions") %>%
  select(Zone,Indicateur,Periode,Valeur) %>%
  group_by(Zone,Indicateur,Periode) %>%
  summarise(nb_valeur_secret= n())

DEP_A_par_zone_indic_et_periode <- A %>%
  filter (TypeZone == "Départements") %>%
  select(CodeZone,Zone,Indicateur,Periode,Valeur) %>%
  group_by(CodeZone,Zone,Indicateur,Periode) %>%
  summarise(nb_valeur_secret= n())

EPCI_A_par_zone_indic_et_periode <- A %>%
  filter (TypeZone == "Epci") %>%
  select(CodeZone,Zone,Indicateur,Periode,Valeur) %>%
  group_by(CodeZone,Zone,Indicateur,Periode) %>%
  summarise(nb_valeur_secret= n()) %>%
  ungroup()


# regroupement

REG_T_par_zone_indic_et_periode <- REG_B_par_zone_indic_et_periode %>%
  left_join(REG_A_par_zone_indic_et_periode) %>%
  replace_na(list("nb_valeur_secret"= 0)) %>%
  mutate(part_secret=  paste(round(nb_valeur_secret/nb_valeur_ensemble*100,1),"%"))

DEP_T_par_zone_indic_et_periode <- DEP_B_par_zone_indic_et_periode %>%
  left_join(DEP_A_par_zone_indic_et_periode) %>%
  replace_na(list("nb_valeur_secret"= 0)) %>%
  mutate(part_secret=  paste(round(nb_valeur_secret/nb_valeur_ensemble*100,1),"%")) %>%
  left_join(departements %>% select(CodeZone = DEP,Region = REG))


EPCI_T_par_zone_indic_et_periode <- EPCI_B_par_zone_indic_et_periode %>%
  left_join(EPCI_A_par_zone_indic_et_periode) %>%
  replace_na(list("nb_valeur_secret"= 0)) %>%
  mutate(part_secret=  paste(round(nb_valeur_secret/nb_valeur_ensemble*100,1),"%")) %>%
  left_join(epci %>% select(CodeZone = EPCI,Departement = DEPARTEMENTS_DE_L_EPCI))

# creation fichier excel
l2 <- list("Regions" = REG_T_par_zone_indic_et_periode, "Departements" = DEP_T_par_zone_indic_et_periode, "Epci" = EPCI_T_par_zone_indic_et_periode)
write.xlsx(l2, "data-raw/analyse_secret2.xlsx", colWidths = "auto")






# creation fichier excel
l <- list("par_typezone_et_periode" = pdl_T_par_typezone_et_periode, "par_typezone" = pdl_T_par_typezone, "par_typezone_et_indic" = T_par_typezone_et_indic)
write.xlsx(l, "data-raw/pdl_analyse_secret.xlsx", colWidths = "auto")

