# analyse secrétisation
# faire tourner les scripts jusqu'à la 4e ligne du script 4.
# Pour info, la table identique non secrétisée est la la table ecln_00 créée dans le script 2,
# qui comporte le même nombre de lignes.
#  l'analyse se fait sur la tables ecln_regroup dans laquelle on va compter le nombre de NA

library(tidyr)
library(openxlsx)


nb_de_periodes <- ecln_regroup %>%
  select(Periode) %>%
  pull() %>% unique() %>% nlevels() %>%  as.numeric()

# donnees non secretisees
B <- ecln_regroup

B_par_typezone_et_periode <- B %>%
  select(TypeZone,Periode,Valeur) %>%
  group_by(TypeZone,Periode) %>%
  summarise(nb_valeur_ensemble = n()) # on peut vérifier qu'on a le même nombre de valeur chaque trimestre
# donc que le "complete" a bien fonctionné

B_par_typezone <- B %>%
  select(TypeZone,Valeur) %>%
  group_by(TypeZone) %>%
  summarise(nb_valeur_ensemble = n())

B_par_typezone_et_indic <- B %>%
  select(TypeZone,Indicateur,Valeur) %>%
  group_by(TypeZone,Indicateur) %>%
  summarise(nb_valeur_ensemble = n())


# donnees secretisees
A <- ecln_regroup %>%
  filter (is.na(Valeur))

A_par_typezone_et_periode <- A %>%
  select(TypeZone,Periode,Valeur) %>%
  group_by(TypeZone,Periode) %>%
  summarise(nb_valeur_secret= n())

A_par_typezone <- A %>%
  select(TypeZone,Valeur) %>%
  group_by(TypeZone) %>%
  summarise(nb_valeur_secret= n())

A_par_typezone_et_indic <- A %>%
  select(TypeZone,Indicateur,Valeur) %>%
  group_by(TypeZone,Indicateur) %>%
  summarise(nb_valeur_secret = n())


# regroupement

T_par_typezone_et_periode <- B_par_typezone_et_periode %>%
  left_join(A_par_typezone_et_periode) %>%
  replace_na(list("nb_valeur_secret"= 0)) %>%
  mutate(part_secret=  paste(round(nb_valeur_secret/nb_valeur_ensemble*100,1),"%"))


T_par_typezone <- B_par_typezone %>%
  left_join(A_par_typezone) %>%
  replace_na(list("nb_valeur_secret"= 0)) %>%
  mutate(part_secret=  paste(round(nb_valeur_secret/nb_valeur_ensemble*100,1),"%"))

T_par_typezone_et_indic <- B_par_typezone_et_indic %>%
  left_join(A_par_typezone_et_indic) %>%
  replace_na(list("nb_valeur_secret"= 0)) %>%
  mutate(part_secret=  paste(round(nb_valeur_secret/nb_valeur_ensemble*100,1),"%"))


# creation fichier excel
l <- list("par_typezone_et_periode" = T_par_typezone_et_periode, "par_typezone" = T_par_typezone, "par_typezone_et_indic" = T_par_typezone_et_indic)
write.xlsx(l, "data-raw/analyse_secret.xlsx", colWidths = "auto")


