library(COGiter)

ma_region <- "52"
mes_epci <- list_epci_in_reg(ma_region)
mes_departements <- list_dep_in_reg(ma_region)


indic_ecln <- indic_ecln %>%
  filter(!(TypeZone == "Régions" & CodeZone != ma_region),   #enlève les régions hors région
         !(TypeZone == "Départements" & !(CodeZone %in% mes_departements)),   #enlève les départements hors région
         !(TypeZone == "Epci" & !(CodeZone %in% mes_epci)),   #enlève les EPCI hors région
         )

usethis::use_data(indic_ecln, overwrite = TRUE)
