library(readxl)



# Ajout des tranches
tranches_ecln <- read_excel("data-raw/tranches_ecln.xls")
ecln_secret_11 <- left_join(ecln_secret_10, tranches_ecln, by= "Indicateur") %>%
  select(-Indicateur2)

# application de la règle des 85 % (on secrétise si un promoteur représente plus de 85 %)
# Pour simplifier, lorsque qu'un promoteur représente plus de 85% (part_max>0.85), on remplace la valeur nb_promoteurs par 1
# Ce qui assure que la donnée sera secrétisée
ecln_secret_11 <- ecln_secret_11 %>%
  mutate( nb_promoteurs_reel = nb_promoteurs,  # conservation de la valeur réelle du nombre de promoteurs
          nb_promoteurs = case_when(
    part_max > 0.85 ~ 1,
    TRUE ~ nb_promoteurs
  ))




# secretisation des EPCI --------------------------------------------------------------------------------------------------

secret_epci<- ecln_secret_11 %>%
  filter(TypeZone =="Epci")

#secret induit,
#pour un même indicateur et un même département, pour ne pas retrouver la valeur d'un Epci
#en faisant la somme des variables de l'EPCI

secret_epci1<- secret_epci %>%
  group_by(Indicateur,DEP,Periode) %>%
  mutate(A_nb_inf3=length(which(nb_promoteurs<3))) %>% #compte combien inférieur à 3
  mutate(A_rang=rank(nb_promoteurs, ties.method = "first")) %>%  #classe pour repérer les 2 plus petites valeurs
  mutate(A_sec = case_when(
    nb_promoteurs<3 ~ 1,      #secret pour toutes les nb_promoteurs inférieurs à 3
    A_nb_inf3== 0 ~ 0,   #enlève le secret si aucune des communes rang 1 et 2 inférieur à 3
    A_rang<3 ~ 1,         #secret sur les 2 communes avec valeurs les plus basses
    TRUE ~ 0))


# secret induit, pour un même Epci, une même categorie et un même trimestre, pour ne pas retrouver la valeur d'une variable
# en faisant la somme des variables de l'EPCI

secret_epci1<- secret_epci1 %>%
  group_by(TypeZone,categorie,CodeZone,Periode) %>%
  mutate(B_nb_inf3=length(which(nb_promoteurs<3))) %>% #compte combien inférieur à 3
  mutate(B_sec = case_when(   # créé une colonne qui affiche 1 quand la donnée est à secrétiser
    nb_promoteurs<3 ~ 1,      #secret primaire pour toutes les valeurs inférieures à 3
    B_nb_inf3 > 0 ~ 1,   # secret induit si au moins 1 des 2 valeurs a moins de 3 promoteurs
    TRUE ~ 0))

# masque le collectif pour un Epci dont l'individuel a été masqué par le secret induit
secret_epci2 <- secret_epci1 %>%
  mutate (somme_secrets = A_sec + B_sec) %>%
  group_by(CodeZone,categorie,Periode) %>%             #pour chaque Epci
  mutate(a_secretiser=length(which(somme_secrets>0)))  # secretise toutes les donnes groupees

# regroupement des secrets, masquage des valeurs
secret_epci3<-secret_epci2 %>%
  # mutate(Valeur=as.character(Valeur)) %>%
  mutate(Valeur=case_when(         # masquage des valeurs
    a_secretiser > 0 ~ NA,         #remplace valeur par NA si secret stat
    TRUE ~ Valeur)) %>%              # sinon garde sa valeur
  ungroup() %>%
  select(TypeZone,CodeZone,Zone,Periode,Indicateur,Valeur,nb_promoteurs_reel)


# secretisation des Départements ------------------------------------------------------------------------------------------

secret_dep<- ecln_secret_11 %>%
  filter(TypeZone =="Départements")

#secret induit,
#pour un même indicateur et une même région, pour ne pas retrouver la valeur d'un département
#en faisant la somme des variables du département

secret_dep1<- secret_dep %>%
  group_by(Indicateur,REG,Periode) %>%
  mutate(A_nb_inf3=length(which(nb_promoteurs<3))) %>% #compte combien inférieur à 3
  mutate(A_rang=rank(nb_promoteurs, ties.method = "first")) %>%  #classe pour repérer les 2 plus petites valeurs
  mutate(A_sec = case_when(
    nb_promoteurs<3 ~ 1,      #secret pour toutes les nb_promoteurs inférieurs à 3
    A_nb_inf3== 0 ~ 0,   #enlève le secret si aucune des communes rang 1 et 2 inférieur à 3
    A_rang<3 ~ 1,         #secret sur les 2 communes avec valeurs les plus basses
  TRUE ~ 0))


# secret induit, pour un même Département,une meme categorie et un meme trimestre, pour ne pas retrouver la valeur d'une variable
# en faisant la somme des variables du Département

secret_dep1<- secret_dep1 %>%
  group_by(TypeZone,categorie,CodeZone,Periode) %>%
  mutate(B_nb_inf3=length(which(nb_promoteurs<3))) %>% #compte combien inférieur à 3
  mutate(B_sec = case_when(   # créé une colonne qui affiche 1 quand la donnée est à secrétiser
    nb_promoteurs<3 ~ 1,      #secret primaire pour toutes les valeurs inférieures à 3
    B_nb_inf3 > 0 ~ 1,   # secret induit si au moins 1 des 2 valeurs a moins de 3 promoteurs
    TRUE ~ 0))

# masque le collectif pour un département dont l'individuel a été masqué par le secret induit
secret_dep2 <- secret_dep1 %>%
  mutate (somme_secrets = A_sec + B_sec) %>%
  group_by(CodeZone,categorie,Periode) %>%             #pour chaque departement
  mutate(a_secretiser=length(which(somme_secrets>0)))  # secretise toutes les donnes groupees

# regroupement des secrets, masquage des valeurs
secret_dep3<-secret_dep2 %>%
  # mutate(Valeur=as.character(Valeur)) %>%
  mutate(Valeur=case_when(         # masquage des valeurs
  a_secretiser > 0 ~ NA,         #remplace valeur par NA si secret stat
  TRUE ~ Valeur)) %>%              # sinon garde sa valeur
  ungroup() %>%
  select(TypeZone,CodeZone,Zone,Periode,Indicateur,Valeur,nb_promoteurs_reel)

# secretisation des régions et France--------------------------------------------------------------------------------------------------
# pas de secrétisation en fonction des données supra

secret_reg<- ecln_secret_11 %>%
  filter(TypeZone =="Régions" | TypeZone =="France")

# secret induit, pour une même région,une meme categorie et un meme trimestre, pour ne pas retrouver la valeur d'une variable
# en faisant la somme des variables de la région

secret_reg1<- secret_reg %>%
  group_by(TypeZone,categorie,CodeZone,Periode) %>%
  mutate(B_nb_inf3=length(which(nb_promoteurs<3))) %>% #compte combien inférieur à 3
  mutate(B_sec = case_when(   # créé une colonne qui affiche 1 quand la donnée est à secrétiser
    nb_promoteurs<3 ~ 1,      #secret primaire pour toutes les valeurs inférieures à 3
    B_nb_inf3 > 0 ~ 1,   # secret induit si au moins 1 des 2 valeurs a moins de 3 promoteurs
    TRUE ~ 0))

# masque le collectif pour un département dont l'individuel a été masqué par le secret induit
secret_reg2 <- secret_reg1 %>%
  mutate (somme_secrets = B_sec) %>%
  group_by(CodeZone,categorie,Periode) %>%             #pour chaque région
  mutate(a_secretiser=length(which(somme_secrets>0)))  # secretise toutes les donnes groupees

# regroupement des secrets, masquage des valeurs
secret_reg3<-secret_reg2 %>%
  # mutate(Valeur=as.character(Valeur)) %>%
  mutate(Valeur=case_when(         # masquage des valeurs
    a_secretiser > 0 ~ NA,         #remplace valeur par "nc" si secret stat
    TRUE ~ Valeur)) %>%              # sinon garde sa valeur
  ungroup() %>%
  select(TypeZone,CodeZone,Zone,Periode,Indicateur,Valeur,nb_promoteurs_reel)

# regroupement des zonages -------------------------------------------------------------------------------------------------------------

ecln_secret20 <-bind_rows(secret_epci3,secret_dep3,secret_reg3) %>%
  mutate_if(is.character,as.factor) %>%
  select(-nb_promoteurs_reel)

rm(ecln_secret_10,ecln_secret_11,secret_dep,secret_dep1,secret_dep2,secret_dep3,
   secret_epci,secret_epci1,secret_epci2,secret_epci3,secret_reg,secret_reg1,
   secret_reg2,secret_reg3,tranches_ecln)

