
library(dplyr)
library(tidyr)
library(forcats)
library(stringr)


# mise au format long de la table type de logement
ecln_type_lgt2 <- indic_typ %>%
  gather(Indicateur, Valeur, mev_t:surface) %>%
  mutate(
    id_type_lgt = fct_recode(id_type_lgt, Maisons = "1", Appartements = "2", Logements = "3"),
    Indicateur = fct_recode(factor(Indicateur), `Mises en vente` = "mev_t", Ventes = "nb_resa", Encours = "stock_fin", Prix = "prix", Surface = "surface"),
    Indicateur = str_c(Indicateur, " - ", id_type_lgt),
    Indicateur = as.factor(Indicateur)
  ) %>%
  select(-id_type_lgt) %>%
  mutate(Valeur = ifelse(is.na(Valeur), 0, Valeur))

# mise au format long de la table nature du projet
ecln_nature_proj2 <- indic_nat %>%
  gather(Indicateur, Valeur, mev_t:surface) %>%
  mutate(
    id_nature_projet = fct_recode(id_nature_projet, "Constructions neuves" = "1", "Constructions sur existant" = "2"),
    Indicateur = fct_recode(factor(Indicateur), `Mises en vente` = "mev_t", Ventes = "nb_resa", Encours = "stock_fin", Prix = "prix", Surface = "surface"),
    Indicateur = str_c(Indicateur, " - ", id_nature_projet),
    Indicateur = as.factor(Indicateur)
  ) %>%
  select(-id_nature_projet) %>%
  mutate(Valeur = ifelse(is.na(Valeur), 0, Valeur))


# regroupement type logement et nature du projet-----------------------------------------------------------

ecln_00 <- bind_rows(ecln_type_lgt2,ecln_nature_proj2) #regroupement des données

promoteurs_00 <- full_join(regroup_typ,regroup_nat) #regroupement des données promoteurs


# distinction des données à secrétiser ---------

## données publiques
ecln_publique1 <- ecln_00  %>%
  filter(grepl("Mises en vente", Indicateur))   #garde les mise en vente
ecln_publique2 <- ecln_00  %>%
  #enlève les prix et les mise en vente, pour ne garder que les réservations et en cours
  filter(!grepl("Prix", Indicateur),!grepl("Mises en vente", Indicateur)) %>%
  #garde les grandes zones ou les Epci de plus de 50000 habitants
  filter(TypeZone %in% c("France","Région","Départements") | CodeZone %in% Epci_plus_50000)
# additionne les 2 zones diffusables
ecln_publique <- bind_rows(ecln_publique1,ecln_publique2) %>%
  distinct()

## donnees à secrétiser
ecln_secret1 <- ecln_00  %>%
  # conserve les prix sur tous les zonages, ainsi que les donnees promoteurs des réservations
  filter(grepl("Prix", Indicateur))
ecln_secret2 <- ecln_00  %>%
  # enlève les prix et les mise en vente, pour ne garder que réservations et en cours
  filter(!grepl("Prix", Indicateur),!grepl("Mises en vente", Indicateur)) %>%
  # enlève les gros zonages pour ne garder que les - de 50000 habitants
  filter(!TypeZone %in% c("France","Région","Départements") , !CodeZone %in% Epci_plus_50000)
# additionne les 2 zones à secrétiser
ecln_secret <- bind_rows(ecln_secret1,ecln_secret2) %>%
  distinct()




# -------------------------------------------------------------------------------
# ajout des données promoteurs

 ecln_secret_10 <- ecln_secret %>%
   # ajout de la table des promoteurs
   left_join(promoteurs_00) %>%
   # creation des 2 colonnes promoteurs (nb et part) en choisissant la valeur dans la bonne colonne
   mutate(nb_promoteurs = case_when(
      Indicateur == "Ventes - Appartements" ~ nb_promoteurs_resa_appartements ,
      Indicateur == "Ventes - Maisons" ~ nb_promoteurs_resa_maisons ,
      Indicateur == "Ventes - Logements" ~ nb_promoteurs_resa_total ,
      Indicateur == "Prix - Appartements" ~ nb_promoteurs_resa_appartements ,
      Indicateur == "Prix - Maisons" ~ nb_promoteurs_resa_maisons ,
      Indicateur == "Prix - Logements" ~ nb_promoteurs_resa_total ,
      Indicateur == "Surface - Appartements" ~ nb_promoteurs_resa_appartements ,
      Indicateur == "Surface - Maisons" ~ nb_promoteurs_resa_maisons ,
      Indicateur == "Surface - Logements" ~ nb_promoteurs_resa_total ,
      Indicateur == "Encours - Appartements" ~ nb_promoteurs_stock_appartements ,
      Indicateur == "Encours - Maisons" ~ nb_promoteurs_stock_maisons ,
      Indicateur == "Encours - Logements" ~ nb_promoteurs_stock_total ,

      Indicateur == "Ventes - Constructions neuves" ~ nb_promoteurs_resa_construction_neuve ,
      Indicateur == "Ventes - Constructions sur existant" ~ nb_promoteurs_resa_construction_sur_existant ,
      Indicateur == "Prix - Constructions neuves" ~ nb_promoteurs_resa_construction_neuve ,
      Indicateur == "Prix - Constructions sur existant" ~ nb_promoteurs_resa_construction_sur_existant ,
      Indicateur == "Surface - Constructions neuves" ~ nb_promoteurs_resa_construction_neuve ,
      Indicateur == "Surface - Constructions sur existant" ~ nb_promoteurs_resa_construction_sur_existant ,
      Indicateur == "Encours - Constructions neuves" ~ nb_promoteurs_stock_construction_neuve ,
      Indicateur == "Encours - Constructions sur existant" ~ nb_promoteurs_stock_construction_sur_existant ,
      TRUE ~ NA                )) %>%
   mutate(part_max = case_when(
     Indicateur == "Ventes - Appartements" ~ part_max_resa_appartements ,
     Indicateur == "Ventes - Maisons" ~ part_max_resa_maisons ,
     Indicateur == "Ventes - Logements" ~ part_max_resa_total ,
     Indicateur == "Prix - Appartements" ~ part_max_resa_appartements ,
     Indicateur == "Prix - Maisons" ~ part_max_resa_maisons ,
     Indicateur == "Prix - Logements" ~ part_max_resa_total ,
     Indicateur == "Surface - Appartements" ~ part_max_resa_appartements ,
     Indicateur == "Surface - Maisons" ~ part_max_resa_maisons ,
     Indicateur == "Surface - Logements" ~ part_max_resa_total ,
     Indicateur == "Encours - Appartements" ~ part_max_stock_appartements ,
     Indicateur == "Encours - Maisons" ~ part_max_stock_maisons ,
     Indicateur == "Encours - Logements" ~ part_max_stock_total ,

     Indicateur == "Ventes - Constructions neuves" ~ part_max_resa_construction_neuve ,
     Indicateur == "Ventes - Constructions sur existant" ~ part_max_resa_construction_sur_existant ,
     Indicateur == "Prix - Constructions neuves" ~ part_max_resa_construction_neuve ,
     Indicateur == "Prix - Constructions sur existant" ~ part_max_resa_construction_sur_existant ,
     Indicateur == "Surface - Constructions neuves" ~ part_max_resa_construction_neuve ,
     Indicateur == "Surface - Constructions sur existant" ~ part_max_resa_construction_sur_existant ,
     Indicateur == "Encours - Constructions neuves" ~ part_max_stock_construction_neuve ,
     Indicateur == "Encours - Constructions sur existant" ~ part_max_stock_construction_sur_existant ,
     TRUE ~ NA                )) %>%
   select(TypeZone,CodeZone,Zone,Periode,Indicateur,Valeur,nb_promoteurs,part_max) %>%
   mutate_if(is.character,as.factor) %>%
   # ajout des zonages supra
   left_join(liste_zone, by= c("CodeZone","TypeZone","Zone")) %>%
   select(-EPCI, -NATURE_EPCI)


rm(indic_nat,indic_typ, ecln_type_lgt2,ecln_nature_proj2,regroup_typ,regroup_nat)
rm(ecln_publique1,ecln_publique2,ecln_secret1,ecln_secret2,ecln_00,promoteurs_00,ecln_secret)
